/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.sharepoint.internal.paging;

import com.google.common.collect.Lists;
import com.mulesoft.connectors.sharepoint.internal.config.SharepointConfiguration;
import com.mulesoft.connectors.sharepoint.internal.connection.SharepointConnection;
import com.mulesoft.connectors.sharepoint.internal.metadata.specialist.operations.ItemPropertyMapper;
import com.mulesoft.connectors.sharepoint.internal.metadata.specialist.operations.manager.MetadataManager;
import com.mulesoft.connectors.sharepoint.internal.paging.GraphCycleDetection;
import com.mulesoft.connectors.sharepoint.internal.paging.TaxonomyResolutionContext;
import com.mulesoft.connectors.sharepoint.internal.paging.TaxonomyResolutionProvider;
import com.mulesoft.connectors.sharepoint.internal.service.SharepointService;
import com.mulesoft.connectors.sharepoint.internal.service.SharepointServiceFactory;
import com.mulesoft.connectors.sharepoint.internal.service.mapping.entity.SharepointListItemResults;
import com.mulesoft.connectors.sharepoint.internal.service.mapping.entity.SharepointListMultiValueReference;
import com.mulesoft.connectors.sharepoint.internal.service.mapping.entity.SharepointListReference;
import com.mulesoft.connectors.sharepoint.internal.service.utils.caching.ICacheWRP;
import com.mulesoft.connectors.sharepoint.internal.service.utils.caching.impl.LRUCacheWRP;
import com.mulesoft.connectors.sharepoint.internal.utils.ConnectorUtils;
import com.mulesoft.connectors.sharepoint.internal.utils.SharepointUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriBuilder;
import org.apache.commons.lang.StringUtils;
import org.glassfish.jersey.uri.UriComponent;
import org.glassfish.jersey.uri.UriTemplate;
import org.mule.runtime.extension.api.runtime.streaming.PagingProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SharepointPagingProvider
implements PagingProvider<SharepointConnection, Map<String, Object>> {
    private static final Logger logger = LoggerFactory.getLogger(SharepointPagingProvider.class);
    private static final int MAX_ITEMS_PER_PAGE = 300;
    private static final String SELECT_PARAMETER_NAME = "$select";
    private static final String ORIGINAL_SELECT_PARAMETER_NAME = "o$select";
    private static final String ORIGINAL_SELECT_PARAMETER_NAME_REGEX = "&?" + "o$select".replace("$", "\\$") + "=[^&]*";
    private final ICacheWRP<String, TaxonomyResolutionContext, Object> singleValueTaxonomyCache = new LRUCacheWRP<String, TaxonomyResolutionContext, Object>(15, new TaxonomyResolutionProvider());
    private final boolean fullGraph;
    private final SharepointConfiguration config;
    private String listId;
    private String query;
    private String nextPageUrl;
    private boolean firstPageRequest = true;
    private List<String> originalSelects;
    private List<String> internalSelects;

    public SharepointPagingProvider(String query, boolean fullGraph, SharepointConfiguration config) {
        this.query = query;
        this.fullGraph = fullGraph;
        this.config = config;
    }

    public List<Map<String, Object>> getPage(SharepointConnection sharepointConnection) {
        return sharepointConnection.execute(() -> {
            SharepointListItemResults response;
            SharepointService client = SharepointServiceFactory.getInstance().getClient(this.config, sharepointConnection);
            MetadataManager metadataManager = new MetadataManager(client);
            if (this.firstPageRequest) {
                response = this.onFirstPageRequest(client);
            } else {
                if (ConnectorUtils.isStringNullOrEmpty(this.nextPageUrl)) {
                    return new ArrayList();
                }
                response = this.onSubsequentPageRequest(client);
            }
            return this.handleResponse(client, metadataManager, response);
        });
    }

    private SharepointListItemResults onSubsequentPageRequest(SharepointService client) {
        SharepointListItemResults response = client.getPage(this.nextPageUrl);
        return response;
    }

    private SharepointListItemResults onFirstPageRequest(SharepointService client) {
        this.firstPageRequest = false;
        this.prepareQueryForFirstPageRequest(client);
        return client.getListItems(this.listId, SharepointUtils.extractQueryString(this.query));
    }

    private List<Map<String, Object>> handleResponse(SharepointService client, MetadataManager metadataManager, SharepointListItemResults response) {
        this.nextPageUrl = response.getNext();
        List<Map<String, Object>> results = this.getReferencesIfApplicable(client, metadataManager, response.getResults());
        return new ItemPropertyMapper(metadataManager).mapItemsOut(results, this.originalSelects, this.internalSelects);
    }

    private void prepareQueryForFirstPageRequest(SharepointService client) {
        this.query = SharepointUtils.translateDsqlQuery(client, this.query);
        this.listId = SharepointUtils.extractPath(this.query);
        this.query = SharepointUtils.extractQueryString(this.query);
        UriTemplate uriTemplate = new UriTemplate(this.listId);
        UriBuilder uriBuilder = UriBuilder.fromPath((String)uriTemplate.getTemplate());
        uriBuilder.replaceQuery(this.query);
        MultivaluedMap queryParams = UriComponent.decodeQuery((String)uriBuilder.build(new Object[]{UriTemplate.EMPTY}).getQuery(), (boolean)true);
        this.internalSelects = Arrays.asList(((String)queryParams.getFirst((Object)SELECT_PARAMETER_NAME)).split(","));
        this.createOriginalSelect((MultivaluedMap<String, String>)queryParams);
        if (!queryParams.containsKey((Object)"$top")) {
            uriBuilder.queryParam("$top", new Object[]{300});
        }
        this.query = UriComponent.decode((String)uriBuilder.build(new Object[]{UriTemplate.EMPTY}).toString(), (UriComponent.Type)UriComponent.Type.QUERY_PARAM);
    }

    private void createOriginalSelect(MultivaluedMap<String, String> queryParams) {
        if (queryParams.containsKey((Object)ORIGINAL_SELECT_PARAMETER_NAME)) {
            this.originalSelects = Arrays.asList(((String)queryParams.getFirst((Object)ORIGINAL_SELECT_PARAMETER_NAME)).split(","));
            this.query = this.query.replaceAll(ORIGINAL_SELECT_PARAMETER_NAME_REGEX, "");
        } else {
            this.originalSelects = Arrays.asList(((String)queryParams.getFirst((Object)SELECT_PARAMETER_NAME)).split(","));
        }
    }

    private List<Map<String, Object>> getReferencesIfApplicable(SharepointService client, MetadataManager metadataManager, List<Map<String, Object>> results) {
        for (Map<String, Object> listItem : results) {
            for (Map.Entry<String, Object> entry : listItem.entrySet()) {
                if (metadataManager.isTaxonomyField(this.listId, entry.getKey())) {
                    this.getTaxonomyFieldReference(client, metadataManager, listItem, entry);
                    continue;
                }
                if (!metadataManager.hasLookupList(this.listId, entry.getKey())) continue;
                this.getLookupFieldReference(client, metadataManager, listItem, entry);
            }
        }
        return results;
    }

    private void getTaxonomyFieldReference(SharepointService client, MetadataManager metadataManager, Map<String, Object> item, Map.Entry<String, Object> lookUpField) {
        Object newValue;
        if (this.fullGraph && !metadataManager.isMultiValueField(this.listId, lookUpField.getKey()) && (newValue = this.singleValueTaxonomyCache.resolve(new TaxonomyResolutionContext(client, this.listId, lookUpField, item))) != null) {
            item.put(lookUpField.getKey(), newValue);
        }
    }

    private void getLookupFieldReference(SharepointService client, MetadataManager metadataManager, Map<String, Object> item, Map.Entry<String, Object> lookUpField) {
        String lookUpListId = metadataManager.getReferenceListId(this.listId, lookUpField.getKey());
        if (this.fullGraph) {
            this.getLookupFieldReferenceForFullGraph(client, metadataManager, item, lookUpField, lookUpListId);
        } else {
            this.getLookupFieldsReferenceNoFullGraph(metadataManager, item, lookUpField, lookUpListId);
        }
    }

    private void getLookupFieldsReferenceNoFullGraph(MetadataManager metadataManager, Map<String, Object> item, Map.Entry<String, Object> lookUpField, String lookUpListId) {
        if (metadataManager.isMultiValueField(this.listId, lookUpField.getKey())) {
            List<Integer> ids = this.getMultiValueLookUpObjectsId(item, lookUpField.getKey());
            item.put(lookUpField.getKey(), new SharepointListMultiValueReference(Lists.newArrayList(ids), lookUpListId));
        } else if (lookUpField.getValue() instanceof Integer) {
            item.put(lookUpField.getKey(), new SharepointListReference((Integer)lookUpField.getValue(), lookUpListId));
        } else if (lookUpField.getValue() != null && !this.isReferenceAlreadyResolvedByUserThroughExpand(lookUpField)) {
            item.put(lookUpField.getKey(), new SharepointListReference((Integer)((Map)lookUpField.getValue()).get("Id"), lookUpListId));
        }
    }

    private boolean isReferenceAlreadyResolvedByUserThroughExpand(Map.Entry<String, Object> lookUpField) {
        String[] queryFields;
        String key = lookUpField.getKey();
        Map value = (Map)lookUpField.getValue();
        if (value.containsKey("Id")) {
            return false;
        }
        for (String field : queryFields = StringUtils.substringBefore((String)StringUtils.substringAfter((String)this.query, (String)"select="), (String)"&").split(",")) {
            if (!field.contains("/") || !key.equals(StringUtils.substringBefore((String)field, (String)"/")) || !value.containsKey(StringUtils.substringAfter((String)field, (String)"/"))) continue;
            return true;
        }
        return false;
    }

    private void getLookupFieldReferenceForFullGraph(SharepointService client, MetadataManager metadataManager, Map<String, Object> item, Map.Entry<String, Object> lookUpField, String lookUpListId) {
        GraphCycleDetection<String> graph = new GraphCycleDetection<String>();
        String itemId = this.getItemIdFromMetadata(item);
        String originNode = itemId + this.listId;
        graph.addNode(originNode);
        this.completeFullReference(client, metadataManager, this.listId, item, lookUpField, lookUpListId, graph, originNode);
    }

    private void completeFullReference(SharepointService client, MetadataManager metadataManager, String listId, Map<String, Object> item, Map.Entry<String, Object> lookUpField, String lookUpListId, GraphCycleDetection<String> graph, String originNode) {
        if (metadataManager.isMultiValueField(listId, lookUpField.getKey())) {
            List<Integer> ids = this.getMultiValueLookUpObjectsId(item, lookUpField.getKey());
            ArrayList<Object> innerObjects = new ArrayList<Object>();
            for (Integer id : ids) {
                String destNode = id + lookUpListId;
                graph.addNode(destNode);
                try {
                    graph.addEdge(originNode, destNode, 1.0);
                    innerObjects.add(this.getInner(client, metadataManager, graph, lookUpListId, id));
                }
                catch (IllegalArgumentException e) {
                    innerObjects.add(new SharepointListReference(id, lookUpListId));
                    logger.debug(String.valueOf(e));
                }
            }
            item.put(lookUpField.getKey(), innerObjects);
        } else {
            Integer lookUpObjectId = (Integer)lookUpField.getValue();
            if (lookUpObjectId != null) {
                String destNode = lookUpObjectId + lookUpListId;
                graph.addNode(destNode);
                try {
                    graph.addEdge(originNode, destNode, 1.0);
                    item.put(lookUpField.getKey(), this.getInner(client, metadataManager, graph, lookUpListId, lookUpObjectId));
                }
                catch (IllegalArgumentException e) {
                    item.put(lookUpField.getKey(), new SharepointListReference(lookUpObjectId, lookUpListId));
                    logger.debug(String.valueOf(e));
                }
            }
        }
    }

    private Object getInner(SharepointService client, MetadataManager metadataManager, GraphCycleDetection<String> graph, String listId, Integer id) {
        if (id == null) {
            return null;
        }
        Map<String, Object> lookUpObject = client.getListItemById(listId, id);
        if (lookUpObject != null) {
            lookUpObject.entrySet().stream().filter(lookUpField -> metadataManager.hasLookupList(listId, (String)lookUpField.getKey())).forEach(lookUpField -> {
                String lookUpListId = metadataManager.getReferenceListId(listId, (String)lookUpField.getKey());
                this.completeFullReference(client, metadataManager, listId, lookUpObject, (Map.Entry<String, Object>)lookUpField, lookUpListId, graph, id + listId);
            });
        }
        return lookUpObject;
    }

    private String getItemIdFromMetadata(Map<String, Object> listItem) {
        Map metadata = (Map)listItem.get("__metadata");
        String metadataId = metadata.get("id").toString();
        return ConnectorUtils.substringBefore(ConnectorUtils.substringAfterLast(metadataId, "("), ")");
    }

    private List<Integer> getMultiValueLookUpObjectsId(Map<String, Object> listItem, String fieldName) {
        return (List)((Map)listItem.get(fieldName)).get("results");
    }

    public Optional<Integer> getTotalResults(SharepointConnection sharepointConnection) {
        return Optional.empty();
    }

    public void close(SharepointConnection sharepointConnection) {
        this.query = null;
        this.nextPageUrl = null;
        this.firstPageRequest = true;
    }
}

