/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.sharepoint.internal.metadata.specialist.operations;

import com.fasterxml.jackson.databind.util.ISO8601Utils;
import com.mulesoft.connectors.sharepoint.internal.error.exception.SharepointException;
import com.mulesoft.connectors.sharepoint.internal.metadata.specialist.operations.manager.MetadataManager;
import com.mulesoft.connectors.sharepoint.internal.utils.ConnectorUtils;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.ws.rs.core.UriBuilder;
import org.glassfish.jersey.uri.UriComponent;
import org.glassfish.jersey.uri.UriTemplate;
import org.mule.runtime.extension.api.dsql.Direction;
import org.mule.runtime.extension.api.dsql.EntityType;
import org.mule.runtime.extension.api.dsql.Field;
import org.mule.runtime.extension.api.dsql.OperatorTranslator;
import org.mule.runtime.extension.api.dsql.QueryTranslator;
import org.mule.runtime.extension.api.dsql.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SharepointQueryTranslator
implements QueryTranslator {
    private static final Logger log = LoggerFactory.getLogger(SharepointQueryTranslator.class);
    private static final OperatorTranslator OPERATOR_TRANSLATOR = new SharepointOperatorTranslator();
    private static final String SELECT_PARAMETER_NAME = "$select";
    private static final String EXPAND_PARAMETER_NAME = "$expand";
    private static final String ORIGINAL_SELECT_PARAMETER_NAME = "o$select";
    private static final String ORIGINAL_SELECT_PARAMETER_NAME_REGEX = "&?" + "o$select".replace("$", "\\$") + "=[^&]*";
    private String listId;
    private final UriBuilder uriBuilder;
    private final UriTemplate uriTemplate;
    private final StringBuilder filterStringBuilder;
    private final MetadataManager metadataManager;

    public SharepointQueryTranslator(MetadataManager metadataManager) {
        this.metadataManager = metadataManager;
        this.uriTemplate = new UriTemplate("{listId}");
        this.uriBuilder = UriBuilder.fromPath((String)this.uriTemplate.getTemplate());
        this.filterStringBuilder = new StringBuilder();
    }

    public static String keepOnlyOriginalIfMapped(String oDataQuery) {
        if (oDataQuery.contains(ORIGINAL_SELECT_PARAMETER_NAME)) {
            String tmp = "tmp$query";
            oDataQuery = oDataQuery.replace(ORIGINAL_SELECT_PARAMETER_NAME, tmp).replace(SELECT_PARAMETER_NAME, ORIGINAL_SELECT_PARAMETER_NAME).replace(tmp, SELECT_PARAMETER_NAME).replaceAll(ORIGINAL_SELECT_PARAMETER_NAME_REGEX, "").replace("?&", "?");
        }
        return oDataQuery;
    }

    public void translateFields(List<Field> fields) {
        if (!fields.isEmpty()) {
            ArrayList<String> originalNames = new ArrayList<String>();
            ArrayList<String> mappedNames = new ArrayList<String>();
            HashSet<String> expandFields = new HashSet<String>();
            for (Field field : fields) {
                String fieldName = field.getName();
                originalNames.add(fieldName);
                try {
                    fieldName = this.metadataManager.mapToInternalName(this.listId, field.getName(), false);
                    if (fieldName.contains(".")) {
                        expandFields.add(ConnectorUtils.substringBefore(fieldName, "."));
                        fieldName = fieldName.replace(".", "/");
                    } else if (this.metadataManager.hasLookupList(this.listId, fieldName)) {
                        fieldName = fieldName + "/Id";
                        expandFields.add(fieldName);
                    }
                    mappedNames.add(fieldName);
                }
                catch (SharepointException e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
            String select = ConnectorUtils.join(mappedNames, ",");
            String original = ConnectorUtils.join(originalNames, ",");
            this.uriBuilder.queryParam(SELECT_PARAMETER_NAME, new Object[]{select}).queryParam(ORIGINAL_SELECT_PARAMETER_NAME, new Object[]{original});
            if (!expandFields.isEmpty()) {
                String expand = ConnectorUtils.join(expandFields, ",");
                this.uriBuilder.queryParam(EXPAND_PARAMETER_NAME, new Object[]{expand});
            }
        }
    }

    public void translateTypes(EntityType entityType) {
        this.listId = entityType.getName();
    }

    public void translateOrderByFields(List<Field> fields, Direction direction) {
        if (!fields.isEmpty()) {
            ArrayList<String> fieldNames = new ArrayList<String>();
            for (Field field : fields) {
                String fieldName = field.getName();
                try {
                    fieldName = this.metadataManager.mapToInternalName(this.listId, field.getName(), true);
                }
                catch (SharepointException e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
                String orderedFieldName = direction.equals((Object)Direction.ASC) ? fieldName + " asc" : fieldName + " desc";
                fieldNames.add(orderedFieldName);
            }
            String orederBy = ConnectorUtils.join(fieldNames, ",");
            this.uriBuilder.queryParam("$orderby", new Object[]{orederBy});
        }
    }

    public void translateAnd() {
        this.filterStringBuilder.append(" and ");
    }

    public void translateOR() {
        this.filterStringBuilder.append(" or ");
    }

    public void translateComparison(String operator, Field field, Value<?> value) {
        OperatorTranslator operatorVisitor = this.operatorTranslator();
        String fieldName = field.getName();
        try {
            fieldName = this.metadataManager.mapToInternalName(this.listId, field.getName(), true);
        }
        catch (SharepointException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        fieldName = fieldName.replace(".", "/");
        String valueString = this.returnFilterValue(value);
        if (operatorVisitor.likeOperator().equalsIgnoreCase(operator)) {
            if (!valueString.startsWith("'")) {
                valueString = "'" + valueString;
            }
            if (!valueString.endsWith("'")) {
                valueString = valueString + "'";
            }
            this.filterStringBuilder.append(operator).append("(").append(valueString).append(",").append(fieldName).append(")");
        } else {
            this.filterStringBuilder.append(fieldName).append(operator).append(valueString);
        }
    }

    public void translateBeginExpression() {
    }

    public void translateInitPrecedence() {
        this.filterStringBuilder.append("(");
    }

    public void translateEndPrecedence() {
        this.filterStringBuilder.append(")");
    }

    public void translateLimit(int limit) {
        this.uriBuilder.queryParam("$top", new Object[]{limit});
    }

    public void translateOffset(int offset) {
        this.uriBuilder.queryParam("$skip", new Object[]{offset});
    }

    public String getTranslation() {
        if (this.filterStringBuilder.length() > 0) {
            this.uriBuilder.queryParam("$filter", new Object[]{this.filterStringBuilder.toString()});
        }
        if (this.listId == null) {
            return UriComponent.decode((String)this.uriBuilder.build(new Object[]{UriTemplate.EMPTY}).toString(), (UriComponent.Type)UriComponent.Type.QUERY_PARAM);
        }
        return UriComponent.decode((String)this.uriBuilder.build(new Object[]{this.uriTemplate.createURI(new String[]{this.listId})}).toString(), (UriComponent.Type)UriComponent.Type.QUERY_PARAM);
    }

    public OperatorTranslator operatorTranslator() {
        return OPERATOR_TRANSLATOR;
    }

    private String returnFilterValue(Value<?> value) {
        String result = value.toString();
        try {
            ISO8601Utils.parse((String)result, (ParsePosition)new ParsePosition(0));
            return "datetime'" + result + "'";
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return result;
        }
    }

    public static class DummyQueryTranslator
    implements QueryTranslator {
        private final StringBuilder translation = new StringBuilder("");

        public String getTranslation() {
            return this.translation.toString();
        }

        public void translateAnd() {
            this.translation.append(" AND ");
        }

        public void translateBeginExpression() {
            this.translation.append(" WHERE ");
        }

        public void translateComparison(String operator, Field field, Value<?> value) {
            this.translation.append(field.getName() + operator + value.toString());
        }

        public void translateEndPrecedence() {
        }

        public void translateFields(List<Field> fields) {
            StringBuilder builder = new StringBuilder("");
            for (Field f : fields) {
                if (builder.toString().length() > 0) {
                    builder.append(",");
                }
                builder.append(f.getName());
            }
            this.translation.append(" SELECT ");
            this.translation.append(builder.toString());
        }

        public void translateInitPrecedence() {
        }

        public void translateLimit(int limit) {
            this.translation.append(" LIMIT ").append(limit);
        }

        public void translateOR() {
            this.translation.append(" OR ");
        }

        public void translateOffset(int offset) {
            this.translation.append(" OFFSET ").append(offset);
        }

        public void translateOrderByFields(List<Field> fields, Direction direction) {
            if (!fields.isEmpty()) {
                StringBuilder orderByFields = new StringBuilder("");
                for (Field f : fields) {
                    if (orderByFields.toString().length() > 0) {
                        orderByFields.append(",");
                    }
                    orderByFields.append(f.getName());
                }
                this.translation.append(" ORDER BY ").append((CharSequence)orderByFields).append(" ").append(direction.toString());
            }
        }

        public void translateTypes(EntityType type) {
            this.translation.insert(0, "dsql:").append(" FROM ").append('\'').append(type.getName()).append('\'');
        }
    }

    private static class SharepointOperatorTranslator
    implements OperatorTranslator {
        private SharepointOperatorTranslator() {
        }

        public String lessOperator() {
            return " lt ";
        }

        public String greaterOperator() {
            return " gt ";
        }

        public String lessOrEqualsOperator() {
            return " le ";
        }

        public String equalsOperator() {
            return " eq ";
        }

        public String notEqualsOperator() {
            return " ne ";
        }

        public String greaterOrEqualsOperator() {
            return " ge ";
        }

        public String likeOperator() {
            return "substringof";
        }
    }
}

