/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.sharepoint.internal.metadata.specialist.operations;

import com.mulesoft.connectors.sharepoint.internal.metadata.specialist.operations.manager.MetadataManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ItemPropertyMapper {
    private static final String MULTI_VALUE_LOOKUP_LIST_WRAPPER = "results";
    private final MetadataManager metadataManager;

    public ItemPropertyMapper(MetadataManager metadataManager) {
        this.metadataManager = metadataManager;
    }

    public Map<String, Object> mapItemIn(String listId, Map<String, Object> item, Map<String, String> mappedFields) {
        String[] keys;
        for (String fieldName : keys = item.keySet().toArray(new String[item.keySet().size()])) {
            boolean putOrOverrideEntry = false;
            String internalFieldName = this.metadataManager.mapToInternalName(listId, fieldName, false);
            HashMap value = item.get(fieldName);
            if ((this.metadataManager.isMultiValueField(listId, internalFieldName) || this.metadataManager.isMultiChoiceField(listId, internalFieldName)) && value instanceof List) {
                putOrOverrideEntry = true;
                HashMap wrappedList = new HashMap();
                wrappedList.put(MULTI_VALUE_LOOKUP_LIST_WRAPPER, value);
                value = wrappedList;
            }
            if (!fieldName.equalsIgnoreCase(internalFieldName)) {
                putOrOverrideEntry = true;
                if (mappedFields != null) {
                    mappedFields.put(fieldName, internalFieldName);
                }
                item.remove(fieldName);
            }
            if (!putOrOverrideEntry) continue;
            item.put(internalFieldName, value);
        }
        return item;
    }

    public List<Map<String, Object>> mapItemsOut(List<Map<String, Object>> items, List<String> originalFields, List<String> internalFields) {
        HashMap<String, String> renameFields = new HashMap<String, String>();
        for (int i = 0; i < internalFields.size(); ++i) {
            if (internalFields.get(i).equalsIgnoreCase(originalFields.get(i))) continue;
            renameFields.put(originalFields.get(i), internalFields.get(i));
        }
        for (Map<String, Object> item : items) {
            this.mapItemOut(item, renameFields);
        }
        return items;
    }

    public Map<String, Object> mapItemOut(Map<String, Object> item, List<String> originalFields, List<String> internalFields) {
        ArrayList<Map<String, Object>> temps = new ArrayList<Map<String, Object>>();
        temps.add(item);
        return this.mapItemsOut(temps, originalFields, internalFields).get(0);
    }

    private void mapItemOut(Map<String, Object> item, Map<String, String> renameFields) {
        for (Map.Entry<String, String> renameField : renameFields.entrySet()) {
            item.put(renameField.getKey(), item.get(renameField.getValue()));
            item.remove(renameField.getValue());
        }
    }
}

