/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.sharepoint.internal.metadata.specialist.operations;

import com.mulesoft.connectors.sharepoint.internal.config.SharepointConfiguration;
import com.mulesoft.connectors.sharepoint.internal.connection.SharepointConnection;
import com.mulesoft.connectors.sharepoint.internal.error.SharepointErrorType;
import com.mulesoft.connectors.sharepoint.internal.error.exception.SharepointException;
import com.mulesoft.connectors.sharepoint.internal.metadata.specialist.operations.EntityMetadataResolver;
import com.mulesoft.connectors.sharepoint.internal.metadata.specialist.util.MetadataUtil;
import com.mulesoft.connectors.sharepoint.internal.service.SharepointService;
import com.mulesoft.connectors.sharepoint.internal.service.SharepointServiceFactory;
import java.util.Set;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.ObjectTypeBuilder;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.java.api.JavaTypeLoader;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.metadata.MetadataContext;
import org.mule.runtime.api.metadata.MetadataKey;
import org.mule.runtime.api.metadata.MetadataResolvingException;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;

public class FolderMetadataResolver
extends EntityMetadataResolver {
    public static final String ENTITY_KEY_SUFFIX = "_F";

    public Set<MetadataKey> getEntityKeys(MetadataContext metadataContext) throws MetadataResolvingException, ConnectionException {
        SharepointConnection sharepointConnection = MetadataUtil.extractConnection(metadataContext);
        SharepointConfiguration sharepointConfiguration = MetadataUtil.extractMetadataConfiguration(metadataContext);
        SharepointService client = SharepointServiceFactory.getInstance().getClient(sharepointConfiguration, sharepointConnection);
        try {
            return super.getDocumentsLists(ENTITY_KEY_SUFFIX, client);
        }
        catch (SharepointException e) {
            throw new ModuleException(e.getMessage(), (ErrorTypeDefinition)SharepointErrorType.UNKNOWN, (Throwable)e);
        }
    }

    public MetadataType getEntityMetadata(MetadataContext metadataContext, String metadataKey) throws MetadataResolvingException, ConnectionException {
        BaseTypeBuilder typeBuilder = new BaseTypeBuilder(JavaTypeLoader.JAVA);
        ObjectTypeBuilder dynamicObjectBuilder = typeBuilder.objectType().id(metadataKey);
        dynamicObjectBuilder.addField().key("Name").value().stringType();
        dynamicObjectBuilder.addField().key("ServerRelativeUrl").value().stringType();
        dynamicObjectBuilder.addField().key("WelcomePage").value().stringType();
        dynamicObjectBuilder.addField().key("ItemCount").value().numberType();
        dynamicObjectBuilder.addField().key("Files").value().objectType();
        dynamicObjectBuilder.addField().key("ParentFolder").value().objectType();
        dynamicObjectBuilder.addField().key("Folders").value().objectType();
        dynamicObjectBuilder.addField().key("Properties").value().objectType();
        dynamicObjectBuilder.addField().key("ListItemAllFields").value().objectType();
        return dynamicObjectBuilder.build();
    }

    public String getCategoryName() {
        return "Folder";
    }
}

