/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.sharepoint.internal.metadata.specialist.operations;

import com.mulesoft.connectors.sharepoint.api.SharepointListBaseTemplate;
import com.mulesoft.connectors.sharepoint.api.output.SharepointList;
import com.mulesoft.connectors.sharepoint.internal.service.SharepointService;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.mule.runtime.api.metadata.MetadataKey;
import org.mule.runtime.api.metadata.MetadataKeyBuilder;
import org.mule.runtime.api.metadata.resolving.QueryEntityResolver;

public abstract class EntityMetadataResolver
implements QueryEntityResolver {
    public Set<MetadataKey> getDocumentsLists(SharepointService client) {
        return this.getDocumentsLists("", client);
    }

    public Set<MetadataKey> getDocumentsLists(String metadataKeySuffix, SharepointService client) {
        String documentLibraryTemplate = SharepointListBaseTemplate.DOCUMENT_LIBRARY.getValue();
        String pictureLibraryTemplate = SharepointListBaseTemplate.PICTURE_LIBRARY.getValue();
        List<SharepointList> documentsLists = client.getLists("$select=Title,RootFolder/Name&$filter=BaseTemplate eq " + documentLibraryTemplate + " or BaseTemplate eq " + pictureLibraryTemplate + "&$expand=RootFolder");
        Set<Object> metadataKeys = Collections.emptySet();
        if (documentsLists != null) {
            metadataKeys = documentsLists.stream().map(documentList -> MetadataKeyBuilder.newKey((String)(documentList.getRootFolder().get("Name").toString() + metadataKeySuffix)).withDisplayName(documentList.getTitle()).build()).collect(Collectors.toSet());
        }
        return metadataKeys;
    }
}

