/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.sharepoint.internal.connection.provider;

import com.mulesoft.connectors.sharepoint.api.ProxySettings;
import com.mulesoft.connectors.sharepoint.api.SecurityTokenProvider;
import com.mulesoft.connectors.sharepoint.internal.connection.SharepointConnection;
import com.mulesoft.connectors.sharepoint.internal.connection.provider.AbstractSharepointConnectionProvider;
import com.mulesoft.connectors.sharepoint.internal.service.proxy.HttpClientContextPair;
import com.mulesoft.connectors.sharepoint.internal.service.security.LoginService;
import com.mulesoft.connectors.sharepoint.internal.service.utils.AuthUtils;
import com.mulesoft.connectors.sharepoint.internal.utils.ConnectorUtils;
import java.net.URL;
import org.apache.http.protocol.HttpContext;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Summary;

@Deprecated
@Alias(value="security-token")
@DisplayName(value="(DEPRECATED) Security Token")
public class SecurityTokenConnectionProvider
extends AbstractSharepointConnectionProvider {
    @Parameter
    private String securityToken;
    @Parameter
    @Optional
    @DisplayName(value="Security Token Provider")
    @Summary(value="(Optional) Provider instance that will provide the security token when required.")
    private SecurityTokenProvider securityTokenProvider;

    public SharepointConnection connect() throws ConnectionException {
        this.checkCredentialsParameters();
        try {
            LoginService loginService = new LoginService(this.httpClient);
            URL serviceURL = AuthUtils.buildUrl(this.getSiteUrl());
            String computedSecurityToken = this.computeSecurityToken(serviceURL);
            HttpContext httpContext = loginService.login(serviceURL, computedSecurityToken);
            return new SharepointConnection(serviceURL, new HttpClientContextPair(this.httpClient, httpContext));
        }
        catch (ConnectionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConnectionException(e.getMessage(), (Throwable)e);
        }
    }

    private String computeSecurityToken(URL serviceURL) {
        if (ConnectorUtils.isNotEmpty(this.securityToken)) {
            return this.securityToken;
        }
        return this.securityTokenProvider.getSecurityToken(serviceURL);
    }

    private void checkCredentialsParameters() throws ConnectionException {
        if (ConnectorUtils.isEmpty(this.securityToken) && this.securityTokenProvider == null) {
            throw new ConnectionException("Either \"Security token\" or \"Security token provider\" has to be provided.");
        }
    }

    public boolean isDisableCnCheck() {
        return this.disableCnCheck;
    }

    public void setDisableCnCheck(boolean disableCnCheck) {
        this.disableCnCheck = disableCnCheck;
    }

    public String getSecurityToken() {
        return this.securityToken;
    }

    public void setSecurityToken(String securityToken) {
        this.securityToken = securityToken;
    }

    public ProxySettings getProxySettings() {
        return this.proxySettings;
    }

    public void setProxySettings(ProxySettings proxySettings) {
        this.proxySettings = proxySettings;
    }

    public SecurityTokenProvider getSecurityTokenProvider() {
        return this.securityTokenProvider;
    }

    public void setSecurityTokenProvider(SecurityTokenProvider securityTokenProvider) {
        this.securityTokenProvider = securityTokenProvider;
    }
}

