/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.sharepoint.internal.connection.provider;

import com.mulesoft.connectors.sharepoint.api.ProxySettings;
import com.mulesoft.connectors.sharepoint.internal.connection.SharepointConnection;
import com.mulesoft.connectors.sharepoint.internal.connection.provider.AbstractSharepointConnectionProvider;
import com.mulesoft.connectors.sharepoint.internal.error.SharepointErrorType;
import com.mulesoft.connectors.sharepoint.internal.service.proxy.HttpClientContextPair;
import com.mulesoft.connectors.sharepoint.internal.service.security.LoginService;
import com.mulesoft.connectors.sharepoint.internal.service.utils.AuthUtils;
import com.mulesoft.connectors.sharepoint.internal.utils.ConnectorUtils;
import java.net.URL;
import org.apache.http.protocol.HttpContext;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.Password;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;
import org.mule.sdk.api.annotation.semantics.security.Username;

@Alias(value="online")
public class OnlineConnectionProvider
extends AbstractSharepointConnectionProvider {
    @Username
    @Parameter
    private String onlineUsername;
    @org.mule.sdk.api.annotation.semantics.security.Password
    @Parameter
    @Password
    private String onlinePassword;

    public SharepointConnection connect() throws ConnectionException {
        this.checkCredentialsParameters(this.onlineUsername, this.onlinePassword);
        try {
            LoginService loginService = new LoginService(this.httpClient);
            URL serviceURL = AuthUtils.buildUrl(this.getSiteUrl());
            HttpContext httpContext = loginService.login(serviceURL, this.onlineUsername, this.onlinePassword);
            return new SharepointConnection(serviceURL, new HttpClientContextPair(this.httpClient, httpContext));
        }
        catch (ConnectionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConnectionException(e.getMessage(), (Throwable)e);
        }
    }

    private void checkCredentialsParameters(String username, String password) {
        if (ConnectorUtils.isStringNullOrEmpty(username) || ConnectorUtils.isStringNullOrEmpty(password)) {
            throw new ModuleException("Username and password can not be null or empty.", (ErrorTypeDefinition)SharepointErrorType.INVALID_PARAMETERS);
        }
    }

    public String getOnlineUsername() {
        return this.onlineUsername;
    }

    public void setOnlineUsername(String onlineUsername) {
        this.onlineUsername = onlineUsername;
    }

    public String getOnlinePassword() {
        return this.onlinePassword;
    }

    public void setOnlinePassword(String onlinePassword) {
        this.onlinePassword = onlinePassword;
    }

    public Boolean getDisableCnCheck() {
        return this.disableCnCheck;
    }

    public void setDisableCnCheck(Boolean disableCnCheck) {
        this.disableCnCheck = disableCnCheck;
    }

    public ProxySettings getProxySettings() {
        return this.proxySettings;
    }

    public void setProxySettings(ProxySettings proxySettings) {
        this.proxySettings = proxySettings;
    }
}

