/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.sharepoint.internal.connection.provider;

import com.mulesoft.connectors.sharepoint.api.ProxySettings;
import com.mulesoft.connectors.sharepoint.internal.connection.SharepointConnection;
import com.mulesoft.connectors.sharepoint.internal.connection.provider.AbstractBaseSharepointConnectionProvider;
import com.mulesoft.connectors.sharepoint.internal.service.proxy.HttpClientContextPair;
import com.mulesoft.connectors.sharepoint.internal.service.security.LoginService;
import com.mulesoft.connectors.sharepoint.internal.service.security.OktaLoginResult;
import com.mulesoft.connectors.sharepoint.internal.utils.ConnectorUtils;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Password;
import org.mule.sdk.api.annotation.semantics.connectivity.Domain;
import org.mule.sdk.api.annotation.semantics.connectivity.Url;
import org.mule.sdk.api.annotation.semantics.security.SecurityToken;
import org.mule.sdk.api.annotation.semantics.security.Username;

@Alias(value="okta")
public class OktaConnectionProvider
extends AbstractBaseSharepointConnectionProvider {
    private static final String NO_USERNAME_PROVIDED = "Please provide your Okta username.";
    private static final String NO_PASSWORD_PROVIDED = "Please provide your Okta password";
    private static final String NO_OKTA_DOMAIN_PROVIDED = "Please provide your Okta domain: your-domain.okta.com";
    private static final String INVALID_OKTA_API = "Please provide a valid Okta API security token. This security token can be created/provided by the Okta domain admin.";
    private static final String INVALID_SHAREPOINT_EMBEDDED_LINK = "Please provide the Sharepoint Online Embedded link from Okta.";
    private static final String HTTPS = "https://";
    private static final String HTTP = "http://";
    @Username
    @Parameter
    private String oktaUsername;
    @org.mule.sdk.api.annotation.semantics.security.Password
    @Parameter
    @Password
    private String oktaPassword;
    @Domain
    @Parameter
    private String oktaDomain;
    @Url
    @Parameter
    @DisplayName(value="SharePoint Online embedded link from Okta")
    private String sharepointEmbededLink;
    @SecurityToken
    @Parameter
    @DisplayName(value="Okta API token")
    private String oktaApiToken;

    public SharepointConnection connect() throws ConnectionException {
        this.checkCredentialsParameters();
        try {
            LoginService loginService = new LoginService(this.httpClient);
            OktaLoginResult oktaLoginResult = loginService.login(this.sharepointEmbededLink, this.oktaUsername, this.oktaPassword, this.computeOktaUrl(this.oktaDomain), this.oktaApiToken);
            return new SharepointConnection(oktaLoginResult.getSharepointInstanceURL(), new HttpClientContextPair(this.httpClient, oktaLoginResult.getHttpContext()));
        }
        catch (ConnectionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConnectionException(e.getMessage(), (Throwable)e);
        }
    }

    private String computeOktaUrl(String oktaDomain) {
        if (!oktaDomain.contains(HTTPS) && !oktaDomain.contains(HTTP)) {
            oktaDomain = HTTPS + oktaDomain;
        }
        return oktaDomain;
    }

    private void checkCredentialsParameters() throws ConnectionException {
        if (ConnectorUtils.isEmpty(this.oktaUsername)) {
            throw new ConnectionException(NO_USERNAME_PROVIDED);
        }
        if (ConnectorUtils.isEmpty(this.oktaPassword)) {
            throw new ConnectionException(NO_PASSWORD_PROVIDED);
        }
        if (ConnectorUtils.isEmpty(this.oktaDomain)) {
            throw new ConnectionException(NO_OKTA_DOMAIN_PROVIDED);
        }
        if (ConnectorUtils.isEmpty(this.oktaApiToken)) {
            throw new ConnectionException(INVALID_OKTA_API);
        }
        if (ConnectorUtils.isEmpty(this.sharepointEmbededLink)) {
            throw new ConnectionException(INVALID_SHAREPOINT_EMBEDDED_LINK);
        }
    }

    public String getOktaUsername() {
        return this.oktaUsername;
    }

    public void setUsername(String oktaUsername) {
        this.oktaUsername = oktaUsername;
    }

    public String getOktaPassword() {
        return this.oktaPassword;
    }

    public void setOktaPassword(String password) {
        this.oktaPassword = password;
    }

    public String getOktaDomain() {
        return this.oktaDomain;
    }

    public void setOktaDomain(String oktaDomain) {
        this.oktaDomain = oktaDomain;
    }

    public String getOktaApiToken() {
        return this.oktaApiToken;
    }

    public void setOktaApiToken(String oktaApiToken) {
        this.oktaApiToken = oktaApiToken;
    }

    public String getSharepointEmbededLink() {
        return this.sharepointEmbededLink;
    }

    public void setSharepointEmbededLink(String sharepointEmbededLink) {
        this.sharepointEmbededLink = sharepointEmbededLink;
    }

    public boolean isDisableCnCheck() {
        return this.disableCnCheck;
    }

    public void setDisableCnCheck(boolean disableCnCheck) {
        this.disableCnCheck = disableCnCheck;
    }

    public ProxySettings getProxySettings() {
        return this.proxySettings;
    }

    public void setProxySettings(ProxySettings proxySettings) {
        this.proxySettings = proxySettings;
    }
}

