/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.sharepoint.internal.connection.provider;

import com.mulesoft.connectors.sharepoint.api.ProxySettings;
import com.mulesoft.connectors.sharepoint.internal.connection.NTLMSharepointConnection;
import com.mulesoft.connectors.sharepoint.internal.connection.SharepointConnection;
import com.mulesoft.connectors.sharepoint.internal.connection.provider.AbstractSharepointConnectionProvider;
import com.mulesoft.connectors.sharepoint.internal.error.SharepointErrorType;
import com.mulesoft.connectors.sharepoint.internal.service.proxy.HttpClientContextPair;
import com.mulesoft.connectors.sharepoint.internal.service.security.LoginService;
import com.mulesoft.connectors.sharepoint.internal.service.security.NtlmLogin;
import com.mulesoft.connectors.sharepoint.internal.service.utils.AuthUtils;
import com.mulesoft.connectors.sharepoint.internal.utils.ConnectorUtils;
import com.mulesoft.connectors.sharepoint.internal.utils.HttpClientFactory;
import org.apache.http.protocol.HttpContext;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;
import org.mule.sdk.api.annotation.semantics.connectivity.NtlmDomain;
import org.mule.sdk.api.annotation.semantics.security.Password;
import org.mule.sdk.api.annotation.semantics.security.Username;

@Alias(value="ntlm")
public class NtlmConnectionProvider
extends AbstractSharepointConnectionProvider {
    @NtlmDomain
    @Parameter
    private String domain;
    @Username
    @Parameter
    private String ntlmUsername;
    @Password
    @Parameter
    private String ntlmPassword;

    @Override
    public void initialise() {
        HttpClientFactory httpClientFactory = new HttpClientFactory();
        this.httpClient = httpClientFactory.createForNTLM(this.disableCnCheck, this.proxySettings);
    }

    public SharepointConnection connect() throws ConnectionException {
        this.checkCredentialsParameters(this.ntlmUsername, this.ntlmPassword);
        try {
            LoginService loginService = new LoginService(this.httpClient);
            NtlmLogin ntlmLogin = this.buildNtlmLoginRequest();
            HttpContext httpContext = loginService.login(ntlmLogin);
            return new NTLMSharepointConnection(ntlmLogin.getServiceUrl(), new HttpClientContextPair(this.httpClient, httpContext));
        }
        catch (ConnectionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConnectionException(e.getMessage(), (Throwable)e);
        }
    }

    private NtlmLogin buildNtlmLoginRequest() throws ConnectionException {
        NtlmLogin ntlmLogin = new NtlmLogin();
        ntlmLogin.setUsername(this.ntlmUsername);
        ntlmLogin.setPassword(this.ntlmPassword);
        ntlmLogin.setDomain(this.domain);
        ntlmLogin.setServiceUrl(AuthUtils.buildUrl(this.getSiteUrl()));
        return ntlmLogin;
    }

    private void checkCredentialsParameters(String username, String password) {
        if (ConnectorUtils.isStringNullOrEmpty(username) || ConnectorUtils.isStringNullOrEmpty(password)) {
            throw new ModuleException("Username and password can not be null or empty.", (ErrorTypeDefinition)SharepointErrorType.INVALID_PARAMETERS);
        }
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public ProxySettings getProxySettings() {
        return this.proxySettings;
    }

    public void setProxySettings(ProxySettings proxySettings) {
        this.proxySettings = proxySettings;
    }

    public String getNtlmUsername() {
        return this.ntlmUsername;
    }

    public void setNtlmUsername(String ntlmUsername) {
        this.ntlmUsername = ntlmUsername;
    }

    public boolean isDisableCnCheck() {
        return this.disableCnCheck;
    }

    public void setDisableCnCheck(boolean disableCnCheck) {
        this.disableCnCheck = disableCnCheck;
    }

    public String getNtlmPassword() {
        return this.ntlmPassword;
    }

    public void setNtlmPassword(String ntlmPassword) {
        this.ntlmPassword = ntlmPassword;
    }
}

