/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.sharepoint.internal.connection.provider;

import com.mulesoft.connectors.sharepoint.api.ProxySettings;
import com.mulesoft.connectors.sharepoint.internal.connection.SharepointConnection;
import com.mulesoft.connectors.sharepoint.internal.utils.HttpClientFactory;
import java.io.IOException;
import org.apache.http.impl.client.CloseableHttpClient;
import org.mule.runtime.api.connection.CachedConnectionProvider;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBaseSharepointConnectionProvider
implements CachedConnectionProvider<SharepointConnection>,
Initialisable,
Disposable {
    private static final Logger logger = LoggerFactory.getLogger(AbstractBaseSharepointConnectionProvider.class);
    protected static final String COULD_NOT_EXTRACT_FIELD = "Could not extract field {0}";
    @Parameter
    @Optional(defaultValue="false")
    @DisplayName(value="Disable SSL certificate validation")
    protected boolean disableCnCheck;
    @ParameterGroup(name="Proxy")
    protected ProxySettings proxySettings;
    protected CloseableHttpClient httpClient;

    public void disconnect(SharepointConnection connection) {
        ConnectionValidationResult connectionValidationResult = this.validate(connection);
        if (!connectionValidationResult.isValid()) {
            logger.warn("Invalid connection");
        } else {
            connection.disconnect();
        }
    }

    public ConnectionValidationResult validate(SharepointConnection connection) {
        try {
            connection.validate();
            return ConnectionValidationResult.success();
        }
        catch (Exception e) {
            return ConnectionValidationResult.failure((String)e.getMessage(), (Exception)e);
        }
    }

    public void initialise() throws InitialisationException {
        HttpClientFactory httpClientFactory = new HttpClientFactory();
        this.httpClient = httpClientFactory.create(this.disableCnCheck, this.proxySettings);
    }

    public void dispose() {
        if (this.httpClient != null) {
            try {
                this.httpClient.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

