/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.sharepoint.internal.connection.oauth.dancer;

import com.mulesoft.connectors.sharepoint.internal.connection.oauth.AssertionGenerator;
import com.mulesoft.connectors.sharepoint.internal.connection.oauth.dancer.ClientCredentialsConfig;
import com.mulesoft.connectors.sharepoint.internal.connection.oauth.dancer.ClientCredentialsOauthDancer;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.el.MuleExpressionLanguage;
import org.mule.runtime.api.lock.LockFactory;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.oauth.api.http.HttpClientFactory;
import org.mule.runtime.oauth.api.listener.ClientCredentialsListener;
import org.mule.runtime.oauth.api.state.ResourceOwnerOAuthContext;
import org.mule.runtime.oauth.internal.builder.AbstractOAuthDancerBuilder;
import org.mule.runtime.oauth.internal.config.TokenParserConfig;

public class ClientCredentialsOauthDancerBuilder
extends AbstractOAuthDancerBuilder<ClientCredentialsOauthDancer> {
    private final List<ClientCredentialsListener> listeners = new LinkedList<ClientCredentialsListener>();
    private AssertionGenerator assertionGenerator;

    public ClientCredentialsOauthDancerBuilder(SchedulerService schedulerService, LockFactory lockProvider, Map<String, ResourceOwnerOAuthContext> tokensStore, HttpClientFactory httpClientFactory, MuleExpressionLanguage expressionEvaluator) {
        super(schedulerService, lockProvider, tokensStore, httpClientFactory, expressionEvaluator);
    }

    public ClientCredentialsOauthDancerBuilder assertionGenerator(AssertionGenerator assertionGenerator) {
        Objects.requireNonNull(assertionGenerator, "assertionGenerator cannot be null");
        this.assertionGenerator = assertionGenerator;
        return this;
    }

    public ClientCredentialsOauthDancer build() {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.clientId), (String)"clientId cannot be null");
        TokenParserConfig tokenParserConfig = TokenParserConfig.builder().withResponseAccessTokenExpr(this.responseAccessTokenExpr).withResponseRefreshTokenExpr(this.responseRefreshTokenExpr).withResponseExpiresInExpr(this.responseExpiresInExpr).build();
        ClientCredentialsConfig clientCredentialsConfig = new ClientCredentialsConfig();
        clientCredentialsConfig.setClientId(this.clientId);
        clientCredentialsConfig.setName(this.name);
        clientCredentialsConfig.setTokenUrl(this.tokenUrl);
        clientCredentialsConfig.setScopes(this.scopes);
        clientCredentialsConfig.setEncoding(this.encoding);
        clientCredentialsConfig.setAssertionGenerator(this.assertionGenerator);
        clientCredentialsConfig.setTokenParserConfig(tokenParserConfig);
        clientCredentialsConfig.setCustomParametersExtractorsExprs(this.customParametersExtractorsExprs);
        clientCredentialsConfig.setResourceOwnerIdTransformer(this.resourceOwnerIdTransformer);
        clientCredentialsConfig.setSchedulerService(this.schedulerService);
        clientCredentialsConfig.setLockProvider(this.lockProvider);
        clientCredentialsConfig.setTokensStore(this.tokensStore);
        clientCredentialsConfig.setHttpClient((HttpClient)this.httpClientFactory.get());
        clientCredentialsConfig.setExpressionEvaluator(this.expressionEvaluator);
        clientCredentialsConfig.setListeners(this.listeners);
        return new ClientCredentialsOauthDancer(clientCredentialsConfig);
    }
}

