/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.sharepoint.internal.connection;

import com.mulesoft.connectors.sharepoint.internal.connection.OAuthSharepointConnection;
import com.mulesoft.connectors.sharepoint.internal.connection.oauth.dancer.ClientCredentialsOauthDancer;
import com.mulesoft.connectors.sharepoint.internal.error.SharepointErrorType;
import com.mulesoft.connectors.sharepoint.internal.service.proxy.HttpClientContextPair;
import com.mulesoft.connectors.sharepoint.internal.service.utils.AuthUtils;
import java.util.concurrent.ExecutionException;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.protocol.HttpContext;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;

public class OAuthClientCredentialsConnection
extends OAuthSharepointConnection {
    private final ClientCredentialsOauthDancer dancer;

    public OAuthClientCredentialsConnection(CloseableHttpClient httpClient, ClientCredentialsOauthDancer dancer, String serviceUrl) throws ConnectionException {
        super(AuthUtils.buildUrl(serviceUrl), new HttpClientContextPair(httpClient, (HttpContext)new HttpClientContext()));
        this.dancer = dancer;
    }

    @Override
    public String getAccessToken() {
        try {
            return this.dancer.accessToken().get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ModuleException(e.getMessage(), (ErrorTypeDefinition)SharepointErrorType.UNKNOWN, (Throwable)e);
        }
        catch (ExecutionException e) {
            throw new ModuleException(e.getMessage(), (ErrorTypeDefinition)SharepointErrorType.UNKNOWN, (Throwable)e);
        }
    }
}

