/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.sharepoint.internal.utils;

import com.mulesoft.connectors.sharepoint.api.ProxySettings;
import com.mulesoft.connectors.sharepoint.internal.error.exception.UnableToCreateHttpClientException;
import com.mulesoft.connectors.sharepoint.internal.service.security.kerberos.SharepointSPNegoSchemeFactory;
import com.mulesoft.connectors.sharepoint.internal.service.utils.http.interceptor.RequestSharepointMultiAuthHeader;
import com.mulesoft.connectors.sharepoint.internal.utils.ConnectorUtils;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.net.ssl.HostnameVerifier;
import jcifs.ntlmssp.Type1Message;
import jcifs.ntlmssp.Type2Message;
import jcifs.ntlmssp.Type3Message;
import jcifs.util.Base64;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthSchemeProvider;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.Lookup;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.auth.NTLMEngine;
import org.apache.http.impl.auth.NTLMEngineException;
import org.apache.http.impl.auth.NTLMScheme;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.protocol.HttpContext;
import org.apache.http.ssl.SSLContextBuilder;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientFactory {
    private static final String INVALID_ENCRYPTION_ALGORITHM = "Invalid encryption algorithm.";
    private static final String UNABLE_TO_HANDLE_KEYSTORE = "Unable to handle keystore.";
    private static final String UNABLE_TO_HANDLE_SECURITY_KEYS = "Unable to handle security keys.";
    private static final Logger logger = LoggerFactory.getLogger(HttpClientFactory.class);

    public CloseableHttpClient createForNTLM(boolean disableCnCheck, ProxySettings proxySettings) {
        HttpClientBuilder httpClientBuilder = this.createHttpClientBuilder(disableCnCheck, proxySettings);
        httpClientBuilder.addInterceptorFirst((HttpRequestInterceptor)new RequestSharepointMultiAuthHeader());
        Registry authSchemeRegistry = RegistryBuilder.create().register("NTLM", (Object)new JCIFSNTLMSchemeFactory()).build();
        httpClientBuilder.setDefaultAuthSchemeRegistry((Lookup)authSchemeRegistry);
        return httpClientBuilder.build();
    }

    public CloseableHttpClient create(boolean disableCnCheck, ProxySettings proxySettings) {
        return this.createHttpClientBuilder(disableCnCheck, proxySettings).build();
    }

    @NotNull
    public HttpClientBuilder createHttpClientBuilder(boolean disableCnCheck, ProxySettings proxySettings) {
        HttpClientBuilder httpClientBuilder = HttpClients.custom().useSystemProperties();
        this.addProxySettings(proxySettings, httpClientBuilder);
        if (disableCnCheck) {
            try {
                SSLContextBuilder builder = new SSLContextBuilder();
                builder.loadTrustMaterial(null, (chain, authType) -> true);
                SSLConnectionSocketFactory sslConnectionSocketFactory = new SSLConnectionSocketFactory(builder.build(), (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
                httpClientBuilder.setSSLSocketFactory((LayeredConnectionSocketFactory)sslConnectionSocketFactory);
            }
            catch (NoSuchAlgorithmException e) {
                logger.error(e.getMessage(), (Throwable)e);
                throw new UnableToCreateHttpClientException(INVALID_ENCRYPTION_ALGORITHM);
            }
            catch (KeyStoreException e) {
                logger.error(e.getMessage(), (Throwable)e);
                throw new UnableToCreateHttpClientException(UNABLE_TO_HANDLE_KEYSTORE);
            }
            catch (KeyManagementException e) {
                logger.error(e.getMessage(), (Throwable)e);
                throw new UnableToCreateHttpClientException(UNABLE_TO_HANDLE_SECURITY_KEYS);
            }
        }
        return httpClientBuilder;
    }

    private void addProxySettings(ProxySettings proxySettings, HttpClientBuilder httpClientBuilder) {
        if (proxySettings != null && ConnectorUtils.isNotEmpty(proxySettings.getHost())) {
            httpClientBuilder.setProxy(new HttpHost(proxySettings.getHost(), proxySettings.getPort().intValue()));
            if (proxySettings.getUsername() != null && proxySettings.getPassword() != null) {
                AuthScope proxyAuthScope = new AuthScope(proxySettings.getHost(), proxySettings.getPort().intValue());
                Object proxyCredentials = !ConnectorUtils.isStringNullOrEmpty(proxySettings.getNtlmDomain()) ? new NTCredentials(proxySettings.getUsername(), proxySettings.getPassword(), proxySettings.getHost(), proxySettings.getNtlmDomain()) : new UsernamePasswordCredentials(proxySettings.getUsername(), proxySettings.getPassword());
                BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
                credsProvider.setCredentials(proxyAuthScope, (Credentials)proxyCredentials);
                httpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credsProvider);
            }
        }
    }

    public CloseableHttpClient createForKerberos(String spn, boolean disableCnCheck, ProxySettings proxySettings) {
        HttpClientBuilder httpClientBuilder = this.createHttpClientBuilder(disableCnCheck, proxySettings);
        RequestConfig requestConfig = RequestConfig.custom().setTargetPreferredAuthSchemes(Arrays.asList("Negotiate")).build();
        httpClientBuilder.setDefaultRequestConfig(requestConfig);
        Registry authSchemeRegistry = RegistryBuilder.create().register("Negotiate", (Object)new SharepointSPNegoSchemeFactory(spn)).build();
        httpClientBuilder.setDefaultAuthSchemeRegistry((Lookup)authSchemeRegistry);
        return httpClientBuilder.build();
    }

    private final class JCIFSEngine
    implements NTLMEngine {
        public static final String INVALID_NTLM_TYPE_2_MESSAGE = "Invalid NTLM type 2 message";
        private static final int TYPE_1_FLAGS = -1610055131;

        private JCIFSEngine() {
        }

        public String generateType1Msg(String domain, String workstation) throws NTLMEngineException {
            Type1Message type1Message = new Type1Message(-1610055131, domain, workstation);
            return Base64.encode((byte[])type1Message.toByteArray());
        }

        public String generateType3Msg(String username, String password, String domain, String workstation, String challenge) throws NTLMEngineException {
            Type2Message type2Message;
            try {
                type2Message = new Type2Message(Base64.decode((String)challenge));
            }
            catch (IOException exception) {
                throw new NTLMEngineException(INVALID_NTLM_TYPE_2_MESSAGE, (Throwable)exception);
            }
            int type2Flags = type2Message.getFlags();
            int type3Flags = type2Flags & 0xFFFCFFFF;
            Type3Message type3Message = new Type3Message(type2Message, password, domain, username, workstation, type3Flags);
            return Base64.encode((byte[])type3Message.toByteArray());
        }
    }

    private class JCIFSNTLMSchemeFactory
    implements AuthSchemeProvider {
        private JCIFSNTLMSchemeFactory() {
        }

        public AuthScheme create(HttpContext context) {
            return new NTLMScheme((NTLMEngine)new JCIFSEngine());
        }
    }
}

