/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.sharepoint.internal.source.specialist;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.mulesoft.connectors.sharepoint.api.TriggersKeysApi;
import com.mulesoft.connectors.sharepoint.api.output.SharepointList;
import com.mulesoft.connectors.sharepoint.internal.error.exception.SharepointException;
import com.mulesoft.connectors.sharepoint.internal.service.SharepointService;
import com.mulesoft.connectors.sharepoint.internal.service.mapping.entity.SharepointListItemResults;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.mule.runtime.core.api.util.StringUtils;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.source.PollContext;

public enum TriggersKeys {
    FILE("File"){

        @Override
        public void executeQuery(PollContext<Map<String, Object>, Serializable> pollContext, SharepointService client, String watermarkField, String since, String listId, boolean recursive, String folderPath) {
            String queryFile = TriggersKeys.TIME_LAST_MODIFIED.equals(watermarkField) ? String.format("$filter=(%s ge datetime'%s') and (%s ne TimeCreated)", watermarkField, since, watermarkField) : String.format(TriggersKeys.FILTER_S_GE_DATETIME_S, watermarkField, since);
            List<Map<String, Object>> files = client.queryForFilesInFolders(queryFile, folderPath, recursive, listId, watermarkField, since);
            if (files != null) {
                this.setResults(pollContext, watermarkField, files);
            }
        }
    }
    ,
    FOLDER("Folder"){

        @Override
        public void executeQuery(PollContext<Map<String, Object>, Serializable> pollContext, SharepointService client, String watermarkField, String since, String listId, boolean recursive, String path) {
            String queryFolder = TriggersKeys.TIME_LAST_MODIFIED.equals(watermarkField) ? String.format("?$filter=(%s ge datetime'%s') and (%s ne TimeCreated)", watermarkField, since, watermarkField) : String.format("?$filter=%s ge datetime'%s'", watermarkField, since);
            List<Map<String, Object>> folders = client.queryFolders(queryFolder, path, recursive);
            if (folders != null) {
                this.setResults(pollContext, watermarkField, folders);
            }
        }
    }
    ,
    LIST("List"){

        @Override
        public void executeQuery(PollContext<Map<String, Object>, Serializable> pollContext, SharepointService client, String watermarkField, String since, String listId, boolean recursive, String path) {
            String queryList = TriggersKeys.LAST_ITEM_MODIFIED_DATE.equalsIgnoreCase(watermarkField) ? String.format("$filter=(%s ge datetime'%s') and (%s ne created)", watermarkField, since, watermarkField) : String.format(TriggersKeys.FILTER_S_GE_DATETIME_S, watermarkField, since);
            List<SharepointList> lists = client.getLists(queryList);
            if (lists != null) {
                for (SharepointList endResult : lists) {
                    String watermark = TriggersKeys.CREATED_LIST.equalsIgnoreCase(watermarkField) ? String.valueOf(endResult.getCreated()) : String.valueOf(endResult.getLastItemModifiedDate());
                    pollContext.accept(item -> item.setResult(this.toResult(endResult)).setWatermark((Serializable)((Object)watermark)).setId(endResult.getId()));
                }
            }
        }
    }
    ,
    LIST_ITEM("ListItems"){

        @Override
        public void executeQuery(PollContext<Map<String, Object>, Serializable> pollContext, SharepointService client, String watermarkField, String since, String listId, boolean recursive, String path) {
            if (StringUtils.isBlank((String)listId)) {
                throw new SharepointException("The list id is required for this object type");
            }
            String queryListItem = String.format(TriggersKeys.FILTER_S_GE_DATETIME_S, watermarkField, since);
            SharepointListItemResults listItems = client.getListItems(listId, queryListItem);
            if (listItems != null && listItems.getResults() != null) {
                for (Map<String, Object> endResult : listItems.getResults()) {
                    if (TriggersKeys.MODIFIED.equals(watermarkField) && endResult.get(TriggersKeys.MODIFIED).equals(endResult.get(TriggersKeys.CREATED_LIST_ITEM))) continue;
                    String watermark = String.valueOf(endResult.get(watermarkField));
                    pollContext.accept(item -> item.setResult(this.toResult(endResult)).setWatermark((Serializable)((Object)watermark)).setId(endResult.get("GUID").toString()));
                }
            }
        }
    };

    private String value;
    private static final String CREATED_LIST = "created";
    private static final String CREATED_LIST_ITEM = "Created";
    private static final String TIME_LAST_MODIFIED = "TimeLastModified";
    private static final String LAST_ITEM_MODIFIED_DATE = "lastItemModifiedDate";
    private static final String MODIFIED = "Modified";
    private static final String FILTER_S_GE_DATETIME_S = "$filter=%s ge datetime'%s'";

    protected void setResults(PollContext<Map<String, Object>, Serializable> pollContext, String watermarkField, List<Map<String, Object>> files) {
        for (Map<String, Object> endResult : files) {
            String watermark = String.valueOf(endResult.get(watermarkField));
            pollContext.accept(item -> item.setResult(this.toResult(endResult)).setWatermark((Serializable)((Object)watermark)).setId(endResult.get("UniqueId").toString()));
        }
    }

    static TriggersKeys fromApiTrigger(TriggersKeysApi triggersKeysApi) {
        switch (triggersKeysApi) {
            case FOLDER: {
                return FOLDER;
            }
            case FILE: {
                return FILE;
            }
            case LIST: {
                return LIST;
            }
            case LIST_ITEM: {
                return LIST_ITEM;
            }
        }
        return null;
    }

    private TriggersKeys(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public abstract void executeQuery(PollContext<Map<String, Object>, Serializable> var1, SharepointService var2, String var3, String var4, String var5, boolean var6, String var7);

    protected Result<Map<String, Object>, Serializable> toResult(Map<String, Object> entity) {
        return Result.builder().output(entity).build();
    }

    protected Result<Map<String, Object>, Serializable> toResult(SharepointList entity) {
        ObjectMapper mapper = new ObjectMapper();
        return Result.builder().output(mapper.convertValue((Object)entity, Map.class)).build();
    }
}

