/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.sharepoint.internal.source.specialist;

import com.mulesoft.connectors.sharepoint.api.DeletedObject;
import com.mulesoft.connectors.sharepoint.internal.config.SharepointConfiguration;
import com.mulesoft.connectors.sharepoint.internal.connection.SharepointConnection;
import com.mulesoft.connectors.sharepoint.internal.service.SharepointService;
import com.mulesoft.connectors.sharepoint.internal.service.SharepointServiceFactory;
import com.mulesoft.connectors.sharepoint.internal.service.mapping.MapperFactory;
import com.mulesoft.connectors.sharepoint.internal.service.mapping.constants.MapperType;
import com.mulesoft.connectors.sharepoint.internal.service.mapping.entity.json.DeletedObjectJson;
import com.mulesoft.connectors.sharepoint.internal.service.mapping.entity.json.DeletedObjectsResultsJson;
import com.mulesoft.connectors.sharepoint.internal.service.mapping.mapper.IMapper;
import com.mulesoft.connectors.sharepoint.internal.source.MicrosoftSharepointTriggerExceptionHandler;
import java.io.Serializable;
import java.time.Clock;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Optional;
import javax.ws.rs.core.UriBuilder;
import org.glassfish.jersey.uri.UriComponent;
import org.glassfish.jersey.uri.UriTemplate;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.source.PollContext;
import org.mule.runtime.extension.api.runtime.source.PollingSource;
import org.mule.runtime.extension.api.runtime.source.SourceCallbackContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Alias(value="deleted-objects", description="Listener for deleted objects.")
@DisplayName(value="On Deleted Objects")
public class DeletedObjectsSource
extends PollingSource<DeletedObject, Serializable> {
    private static final Logger logger = LoggerFactory.getLogger(DeletedObjectsSource.class);
    private static final String WATERMARK_FIELD_DELETED = "DeletedDate";
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss'Z'");
    private IMapper objectMapper = MapperFactory.getMapper(MapperType.MODELMAPPER);
    private MicrosoftSharepointTriggerExceptionHandler handler = new MicrosoftSharepointTriggerExceptionHandler();
    @Parameter
    @org.mule.runtime.extension.api.annotation.param.Optional
    @Summary(value="Required date format is 'yyyy-MM-ddTHH:mm:ssZ")
    protected String since;
    @Config
    protected SharepointConfiguration sharepointConfiguration;
    @Connection
    protected ConnectionProvider<SharepointConnection> connectionProvider;
    protected SharepointConnection connection;
    protected SharepointService client;

    protected void doStart() throws MuleException {
        this.connection = (SharepointConnection)this.connectionProvider.connect();
        this.client = SharepointServiceFactory.getInstance().getClient(this.sharepointConfiguration, this.connection);
        if (this.since == null || this.since.isEmpty()) {
            this.since = LocalDateTime.now(Clock.systemUTC()).format(DATE_TIME_FORMATTER);
        }
    }

    protected void doStop() {
        this.connectionProvider.disconnect((Object)this.connection);
    }

    public void onRejectedItem(Result result, SourceCallbackContext sourceCallbackContext) {
        logger.info("Item rejected: {}", result.getOutput());
    }

    public void poll(PollContext<DeletedObject, Serializable> pollContext) {
        this.handler.handle(pollContext, this.connection, () -> {
            String path = "_api/site/RecycleBin";
            UriTemplate uriTemplate = new UriTemplate(path);
            UriBuilder uriBuilder = UriBuilder.fromPath((String)uriTemplate.getTemplate());
            Optional watermarkValue = pollContext.getWatermark();
            if (watermarkValue.isPresent()) {
                uriBuilder.queryParam("$filter", new Object[]{UriComponent.encode((String)String.format("%s gt datetime'%s'", WATERMARK_FIELD_DELETED, String.valueOf(watermarkValue.get())), (UriComponent.Type)UriComponent.Type.QUERY_PARAM_SPACE_ENCODED)});
            } else {
                uriBuilder.queryParam("$filter", new Object[]{UriComponent.encode((String)String.format("%s gt datetime'%s'", WATERMARK_FIELD_DELETED, this.since), (UriComponent.Type)UriComponent.Type.QUERY_PARAM_SPACE_ENCODED)});
            }
            uriBuilder.queryParam("$orderby", new Object[]{WATERMARK_FIELD_DELETED});
            DeletedObjectsResultsJson deletedObjectResults = this.client.getForObject(uriBuilder.build(new Object[]{UriTemplate.EMPTY}).toString(), DeletedObjectsResultsJson.class, true);
            for (DeletedObjectJson deletedObject : deletedObjectResults.getResults()) {
                String watermark = deletedObject.getDeletedDate();
                pollContext.accept(item -> item.setResult(this.toResult(deletedObject)).setWatermark((Serializable)((Object)watermark)));
            }
            return null;
        });
    }

    private Result<DeletedObject, Serializable> toResult(DeletedObjectJson entity) {
        DeletedObject deletedObject = this.objectMapper.map(entity, DeletedObject.class);
        return Result.builder().output((Object)deletedObject).build();
    }
}

