/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.sharepoint.internal.source.specialist;

import com.mulesoft.connectors.sharepoint.api.TriggersKeysApi;
import com.mulesoft.connectors.sharepoint.internal.config.SharepointConfiguration;
import com.mulesoft.connectors.sharepoint.internal.connection.SharepointConnection;
import com.mulesoft.connectors.sharepoint.internal.service.SharepointService;
import com.mulesoft.connectors.sharepoint.internal.service.SharepointServiceFactory;
import com.mulesoft.connectors.sharepoint.internal.source.MicrosoftSharepointTriggerExceptionHandler;
import java.io.Serializable;
import java.time.Clock;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import java.util.Map;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.source.PollingSource;
import org.mule.runtime.extension.api.runtime.source.SourceCallbackContext;

public abstract class AbstractObjectsSource
extends PollingSource<Map<String, Object>, Serializable> {
    private static final DateTimeFormatter MULE_DATETIME_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.ENGLISH);
    protected MicrosoftSharepointTriggerExceptionHandler handler = new MicrosoftSharepointTriggerExceptionHandler();
    @Config
    protected SharepointConfiguration config;
    @Connection
    protected ConnectionProvider<SharepointConnection> connectionProvider;
    protected SharepointConnection connection;
    protected SharepointService client;
    @Parameter
    @Optional
    @Summary(value="Required date format is 'yyyy-MM-ddTHH:mm:ssZ'. If left empty the UTC moment of time is used as a starting point")
    protected String since;
    @Parameter
    protected TriggersKeysApi objectType;
    @Parameter
    @Optional
    protected String listId;
    @Parameter
    @Optional(defaultValue="false")
    protected boolean recursive;
    @Parameter
    @Optional(defaultValue="/")
    protected String path;

    protected void doStart() throws MuleException {
        this.connection = (SharepointConnection)this.connectionProvider.connect();
        this.client = SharepointServiceFactory.getInstance().getClient(this.config, this.connection);
        if (this.since == null || this.since.isEmpty()) {
            this.since = LocalDateTime.now(Clock.systemUTC()).format(MULE_DATETIME_FORMAT);
        }
    }

    protected void doStop() {
        this.connectionProvider.disconnect((Object)this.connection);
    }

    public void onRejectedItem(Result<Map<String, Object>, Serializable> result, SourceCallbackContext sourceCallbackContext) {
    }
}

