/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.sharepoint.internal.service.utils.caching.impl;

import com.mulesoft.connectors.sharepoint.internal.service.utils.caching.ICacheWRP;
import com.mulesoft.connectors.sharepoint.internal.service.utils.caching.impl.CacheResolutionContext;
import com.mulesoft.connectors.sharepoint.internal.service.utils.caching.impl.CacheResolutionProvider;
import java.util.LinkedHashMap;
import java.util.Map;

public class LRUCacheWRP<K, C extends CacheResolutionContext<K>, V>
extends LinkedHashMap<K, V>
implements ICacheWRP<K, C, V> {
    private static final long serialVersionUID = -9153987374973601205L;
    private final CacheResolutionProvider<K, C, V> missResolver;
    private final int cacheSize;

    public <R extends CacheResolutionProvider<K, C, V>> LRUCacheWRP(int cacheSize, R missResolver) {
        super(cacheSize / 2, 0.75f, true);
        this.cacheSize = cacheSize;
        this.missResolver = missResolver;
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
        return this.size() > this.cacheSize;
    }

    @Override
    public V resolve(C context) {
        Object key = context.getKey();
        return (V)this.computeIfAbsent(key, k -> this.missResolver.resolve((CacheResolutionContext)context));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LRUCacheWRP)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LRUCacheWRP that = (LRUCacheWRP)o;
        if (this.cacheSize != that.cacheSize) {
            return false;
        }
        return this.missResolver.equals(that.missResolver);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.missResolver.hashCode();
        result = 31 * result + this.cacheSize;
        return result;
    }
}

