/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.sharepoint.internal.service.security.kerberos;

import com.mulesoft.connectors.sharepoint.internal.utils.ConnectorUtils;
import java.nio.charset.StandardCharsets;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.auth.AuthenticationException;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.InvalidCredentialsException;
import org.apache.http.auth.MalformedChallengeException;
import org.apache.http.impl.auth.AuthSchemeBase;
import org.apache.http.message.BasicHeader;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.CharArrayBuffer;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SharepointGGSSchemeBase
extends AuthSchemeBase {
    private static final String HTTP_PROXY_HOST = "http.proxy_host";
    private static final String HTTP_TARGET_HOST = "http.target_host";
    private static final String SENDING_RESPONSE_DEBUG_MESSAGE = "Sending response {} back to the auth server";
    private static final String RECEIVED_CHALLENGE_DEBUG_MESSAGE = "Received challenge {} from the auth server";
    private static final Logger logger = LoggerFactory.getLogger(SharepointGGSSchemeBase.class);
    private final Base64 base64codec = new Base64();
    private Boolean isComplete = false;
    private byte[] token;
    private String spn;

    SharepointGGSSchemeBase(String spn) {
        this.spn = spn;
    }

    protected GSSManager getManager() {
        return GSSManager.getInstance();
    }

    protected byte[] generateGSSToken(Credentials credentials, Oid oid, String authServer) throws GSSException {
        if (ConnectorUtils.isBlank(this.spn)) {
            this.spn = "HTTP/" + authServer;
        }
        GSSManager manager = this.getManager();
        GSSName serverName = manager.createName(this.spn, null);
        GSSContext gssContext = manager.createContext(serverName.canonicalize(oid), oid, null, 0);
        gssContext.requestMutualAuth(true);
        gssContext.requestCredDeleg(true);
        return this.getToken(credentials, gssContext);
    }

    private byte[] getToken(Credentials credentials, GSSContext context) throws GSSException {
        LoginContext lc;
        byte[] input = new byte[]{};
        try {
            lc = new LoginContext("Kerberos", this.getUsernamePasswordHandler(credentials.getUserPrincipal().getName(), credentials.getPassword()));
            lc.login();
        }
        catch (LoginException e) {
            throw new GSSException(13, -1, e.getMessage());
        }
        try {
            return Subject.doAs(lc.getSubject(), new CreateServiceTicketAction(context, input));
        }
        catch (PrivilegedActionException e) {
            logger.error(e.getMessage(), (Throwable)e);
            if (e.getCause() instanceof GSSException) {
                throw (GSSException)e.getCause();
            }
            return new byte[0];
        }
    }

    private CallbackHandler getUsernamePasswordHandler(String username, String password) {
        return callback -> {
            for (Callback value : callback) {
                if (value instanceof NameCallback) {
                    NameCallback nameCallback = (NameCallback)value;
                    nameCallback.setName(username);
                    continue;
                }
                if (!(value instanceof PasswordCallback)) continue;
                PasswordCallback passCallback = (PasswordCallback)value;
                passCallback.setPassword(password.toCharArray());
            }
        };
    }

    protected abstract byte[] generateToken(Credentials var1, String var2) throws GSSException;

    public boolean isComplete() {
        return this.isComplete;
    }

    @Deprecated
    public Header authenticate(Credentials credentials, HttpRequest request) throws AuthenticationException {
        return null;
    }

    public Header authenticate(Credentials credentials, HttpRequest request, HttpContext context) throws AuthenticationException {
        try {
            String key = this.isProxy() ? HTTP_PROXY_HOST : HTTP_TARGET_HOST;
            HttpHost host = (HttpHost)context.getAttribute(key);
            String authServer = host.getHostName();
            logger.debug("init {}", (Object)authServer);
            this.token = this.generateToken(credentials, authServer);
            this.isComplete = true;
        }
        catch (GSSException gsse) {
            this.isComplete = true;
            if (gsse.getMajor() == 9 || gsse.getMajor() == 8) {
                throw new InvalidCredentialsException(gsse.getMessage(), (Throwable)gsse);
            }
            if (gsse.getMajor() == 13) {
                throw new InvalidCredentialsException(gsse.getMessage(), (Throwable)gsse);
            }
            throw new AuthenticationException(gsse.getMessage(), (Throwable)gsse);
        }
        String tokenString = new String(this.base64codec.encode(this.token), StandardCharsets.UTF_8);
        logger.debug(SENDING_RESPONSE_DEBUG_MESSAGE, (Object)tokenString);
        return new BasicHeader("Authorization", "Negotiate " + tokenString);
    }

    protected void parseChallenge(CharArrayBuffer buffer, int beginIndex, int endIndex) throws MalformedChallengeException {
        String challenge = buffer.substringTrimmed(beginIndex, endIndex);
        logger.debug(RECEIVED_CHALLENGE_DEBUG_MESSAGE, (Object)challenge);
        this.token = this.base64codec.decode(challenge.getBytes(StandardCharsets.UTF_8));
    }

    private static final class CreateServiceTicketAction
    implements PrivilegedExceptionAction<byte[]> {
        private final GSSContext context;
        private final byte[] token;

        private CreateServiceTicketAction(GSSContext context, byte[] token) {
            this.context = context;
            this.token = token;
        }

        @Override
        public byte[] run() throws GSSException {
            return this.context.initSecContext(this.token, 0, this.token.length);
        }
    }
}

