/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.sharepoint.internal.service.rest;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.google.common.collect.Iterables;
import com.mulesoft.connectors.sharepoint.api.EncodingCharset;
import com.mulesoft.connectors.sharepoint.api.ResolveRequestType;
import com.mulesoft.connectors.sharepoint.api.SharepointList;
import com.mulesoft.connectors.sharepoint.api.output.SharepointFile;
import com.mulesoft.connectors.sharepoint.api.output.SharepointFolder;
import com.mulesoft.connectors.sharepoint.api.output.SharepointList;
import com.mulesoft.connectors.sharepoint.internal.error.SharepointErrorType;
import com.mulesoft.connectors.sharepoint.internal.error.exception.InternalServerException;
import com.mulesoft.connectors.sharepoint.internal.error.exception.SharepointException;
import com.mulesoft.connectors.sharepoint.internal.error.exception.UnableToSendException;
import com.mulesoft.connectors.sharepoint.internal.metadata.specialist.operations.ItemPropertyMapper;
import com.mulesoft.connectors.sharepoint.internal.metadata.specialist.operations.manager.MetadataManager;
import com.mulesoft.connectors.sharepoint.internal.service.SharepointService;
import com.mulesoft.connectors.sharepoint.internal.service.mapping.entity.SharepointBlobEntity;
import com.mulesoft.connectors.sharepoint.internal.service.mapping.entity.SharepointFileResults;
import com.mulesoft.connectors.sharepoint.internal.service.mapping.entity.SharepointListField;
import com.mulesoft.connectors.sharepoint.internal.service.mapping.entity.SharepointListFieldResults;
import com.mulesoft.connectors.sharepoint.internal.service.mapping.entity.SharepointListItem;
import com.mulesoft.connectors.sharepoint.internal.service.mapping.entity.SharepointListItemResults;
import com.mulesoft.connectors.sharepoint.internal.service.mapping.entity.SharepointMapResult;
import com.mulesoft.connectors.sharepoint.internal.service.mapping.entity.json.ContextWebInformationJson;
import com.mulesoft.connectors.sharepoint.internal.service.mapping.entity.json.RecycleFileJson;
import com.mulesoft.connectors.sharepoint.internal.service.mapping.entity.json.SharePointAttachResultJson;
import com.mulesoft.connectors.sharepoint.internal.service.mapping.entity.json.SharePointListResultJson;
import com.mulesoft.connectors.sharepoint.internal.service.mapping.entity.json.SharepointFileJson;
import com.mulesoft.connectors.sharepoint.internal.service.mapping.entity.json.SharepointFileResultsJson;
import com.mulesoft.connectors.sharepoint.internal.service.mapping.entity.json.SharepointFolderJson;
import com.mulesoft.connectors.sharepoint.internal.service.mapping.entity.json.SharepointFolderResultsJson;
import com.mulesoft.connectors.sharepoint.internal.service.mapping.entity.json.SharepointListFieldResultsJson;
import com.mulesoft.connectors.sharepoint.internal.service.mapping.entity.json.SharepointListItemJson;
import com.mulesoft.connectors.sharepoint.internal.service.mapping.entity.json.SharepointListItemResultsJson;
import com.mulesoft.connectors.sharepoint.internal.service.mapping.entity.json.SharepointListJson;
import com.mulesoft.connectors.sharepoint.internal.service.mapping.entity.json.SharepointListOfMapResultJson;
import com.mulesoft.connectors.sharepoint.internal.service.mapping.entity.json.SharepointListResultsJson;
import com.mulesoft.connectors.sharepoint.internal.service.mapping.entity.json.SharepointMapResultJson;
import com.mulesoft.connectors.sharepoint.internal.service.mapping.mapper.impl.ModelMapperBasedMapper;
import com.mulesoft.connectors.sharepoint.internal.service.mapping.mapper.impl.ObjectMapperBasedMapper;
import com.mulesoft.connectors.sharepoint.internal.utils.ConnectorUtils;
import com.mulesoft.connectors.sharepoint.internal.utils.SharepointUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.ws.rs.core.UriBuilder;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicHeader;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.glassfish.jersey.uri.UriComponent;
import org.jetbrains.annotations.Nullable;
import org.mule.runtime.core.api.util.StringUtils;
import org.mule.runtime.extension.api.annotation.param.ConfigOverride;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnpremiseSharepointService
implements SharepointService {
    private static final Logger logger = LoggerFactory.getLogger(OnpremiseSharepointService.class);
    private static final String FILE_COLLECTION_URL = "_api/web/GetFolderByServerRelativeUrl('%s')/Files";
    private static final String CONTENT_TYPE = "content-type";
    private static final String CONTENT_TYPE_VALUE = "application/json;odata=verbose;charset=";
    private static final String ACCEPT = "Accept";
    private static final String ACCEPT_VALUE = "application/json;odata=verbose";
    private static final String X_REQUEST_DIGEST = "X-RequestDigest";
    private static final String IF_MATCH = "IF-MATCH";
    private static final String CODE = "Code: ";
    private static final String MESSAGE = " Message: ";
    private static final String SELECT = "$select=ListItemEntityTypeFullName";
    private static final String SERVER_RELATIVE_URL = "ServerRelativeUrl";
    protected CloseableHttpClient httpClient;
    protected HttpContext httpContext;
    private ModelMapperBasedMapper modelMapper;
    private ObjectMapperBasedMapper objectMapper;
    private URL siteUrl;
    @ConfigOverride
    private EncodingCharset encodingCharset;
    private static final String AND_ENCODED_CHARACTER = "%26";
    private Map<String, String> headers;

    public OnpremiseSharepointService() {
    }

    public OnpremiseSharepointService(EncodingCharset encodingCharset, CloseableHttpClient httpClient, HttpContext httpContext, URL siteUrl, Map<String, String> headers) {
        this.encodingCharset = encodingCharset;
        this.httpClient = httpClient;
        this.httpContext = httpContext;
        this.siteUrl = siteUrl;
        this.objectMapper = ObjectMapperBasedMapper.getInstance();
        this.modelMapper = ModelMapperBasedMapper.getInstance();
        this.headers = headers;
    }

    private String getFormDigestValue() {
        String path = this.getPath("", "_api/contextinfo");
        HttpPost httpPost = new HttpPost(this.getAbsoluteUri(path));
        httpPost.setHeader((Header)new BasicHeader(CONTENT_TYPE, CONTENT_TYPE_VALUE + (Object)((Object)this.encodingCharset)));
        httpPost.setHeader((Header)new BasicHeader(ACCEPT, ACCEPT_VALUE));
        ContextWebInformationJson contextWebInformationJson = this.executeHttp((HttpUriRequest)httpPost, ContextWebInformationJson.class, true);
        return contextWebInformationJson != null ? contextWebInformationJson.getFormDigestValue() : null;
    }

    @Override
    public com.mulesoft.connectors.sharepoint.api.output.SharepointList getList(String id, String query) {
        String path = this.isGuid(id) ? String.format("_api/web/lists(guid'%s')", id) : String.format("_api/web/lists/getbytitle('%s')", id);
        String uri = this.getPath(query, path);
        SharepointListJson jsonPOJOList = this.getForObject(uri, SharepointListJson.class, true);
        return this.modelMapper.map(jsonPOJOList, SharepointList.SharepointListBuilder.class).build();
    }

    @Nullable
    private String getPath(String query, String path) {
        String newUri;
        UriBuilder newUriBuilder = UriBuilder.fromPath((String)path);
        String encodedPath = newUriBuilder.toString();
        if (StringUtils.isEmpty((String)query)) {
            try {
                newUri = new URIBuilder(encodedPath).setCharset(StandardCharsets.UTF_8).build().toString();
            }
            catch (URISyntaxException e) {
                throw new SharepointException(e.getMessage(), e);
            }
        }
        try {
            newUri = new URIBuilder(encodedPath).setCustomQuery(query).setCharset(StandardCharsets.UTF_8).build().toString();
            newUri = this.updateQuerySkippedEncodeCharacter(newUri);
        }
        catch (URISyntaxException e) {
            throw new SharepointException(e.getMessage(), e);
        }
        return newUri;
    }

    @Override
    public Map<String, Object> getListItemById(String listId, Integer id) {
        String filter = "$filter=Id eq " + id;
        String path = this.isGuid(listId) ? String.format("_api/web/lists(guid'%s')/Items", listId) : String.format("_api/web/lists/getbytitle('%s')/Items", listId);
        String uri = this.getPath(filter, path);
        return (Map)Iterables.getFirst(this.getForObject(uri, SharepointListItemResultsJson.class, true).getResults(), null);
    }

    @Override
    public SharepointListItemResults getListItems(String id, String query) {
        String path = this.isGuid(id) ? String.format("_api/web/lists(guid'%s')/Items", id) : String.format("_api/web/lists/getbytitle('%s')/Items", id);
        String newUri = this.getPath(query, path);
        SharepointListItemResultsJson result = this.getForObject(newUri, SharepointListItemResultsJson.class, true);
        return this.modelMapper.map(result, SharepointListItemResults.class);
    }

    @Override
    public List<com.mulesoft.connectors.sharepoint.api.output.SharepointList> getLists(String query) {
        String path = this.getPath(query, "_api/web/lists");
        SharepointListResultsJson forObject = this.getForObject(path, SharepointListResultsJson.class, true);
        return forObject.getResults().stream().map(source -> this.modelMapper.map(source, SharepointList.SharepointListBuilder.class).build()).collect(Collectors.toList());
    }

    @Override
    public List<SharepointListField> getListFields(String id, String query) {
        String path = this.isGuid(id) ? String.format("_api/web/lists(guid'%s')/Fields", id) : String.format("_api/web/lists/getbytitle('%s')/Fields", id);
        String newUri = this.getPath(query, path);
        SharepointListFieldResultsJson original = this.getForObject(newUri, SharepointListFieldResultsJson.class, true);
        return this.modelMapper.map(original, SharepointListFieldResults.class).getResults();
    }

    @Override
    public void deleteList(String id) {
        String path = this.isGuid(id) ? String.format("_api/web/lists(guid'%s')", id) : String.format("_api/web/lists/getbytitle('%s')", this.encodeTitle(id));
        this.delete(path);
    }

    @Override
    public com.mulesoft.connectors.sharepoint.api.output.SharepointList createList(SharepointList list) {
        list = new SharepointList(this.getTypeMap("type", "SP.List"), list);
        SharepointListJson resultInput = this.modelMapper.map(list, SharepointListJson.class);
        SharepointListJson original = this.postForObject("_api/web/lists", resultInput, SharepointListJson.class, true);
        return this.modelMapper.map(original, SharepointList.SharepointListBuilder.class).build();
    }

    private Map<String, Object> getTypeMap(String key, Object value) {
        HashMap<String, Object> typeMap = new HashMap<String, Object>();
        typeMap.put(key, value);
        return typeMap;
    }

    @Override
    public void updateList(String listId, SharepointList list) {
        String path = this.isGuid(listId) ? String.format("_api/web/lists(guid'%s')", listId) : String.format("_api/web/lists/getbytitle('%s')", this.encodeTitle(listId));
        list = new SharepointList(this.getTypeMap("type", "SP.List"), list);
        SharepointListJson resultInput = this.modelMapper.map(list, SharepointListJson.class);
        this.update(path, resultInput, null);
    }

    @Override
    public Map<String, Object> createListItem(String listId, Map<String, Object> properties) {
        HashMap<String, String> mappedFields = new HashMap<String, String>();
        SharepointListItem item = new SharepointListItem();
        ItemPropertyMapper itemPropertyMapper = new ItemPropertyMapper(new MetadataManager(this));
        item.setProperties(itemPropertyMapper.mapItemIn(listId, properties, mappedFields));
        com.mulesoft.connectors.sharepoint.api.output.SharepointList list = this.getList(listId, SELECT);
        item.set("__metadata", this.getTypeMap("type", list.getListItemEntityTypeFullName()));
        String path = this.isGuid(listId) ? String.format("_api/web/lists(guid'%s')/Items", listId) : String.format("_api/web/lists/getbytitle('%s')/Items", this.encodeTitle(listId));
        SharepointListItemJson resultInput = this.modelMapper.map(item, SharepointListItemJson.class);
        SharepointMapResultJson result = this.postForObject(path, resultInput, SharepointMapResultJson.class, true);
        Map<String, Object> createdItem = new HashMap<String, Object>();
        if (result != null) {
            createdItem = result.getResult();
        }
        return itemPropertyMapper.mapItemOut(createdItem, new ArrayList<String>(mappedFields.keySet()), new ArrayList<String>(mappedFields.values()));
    }

    @Override
    public void deleteListItem(String listId, String itemId) {
        String path = this.isGuid(listId) ? String.format("_api/web/lists(guid'%s')/Items(%s)", listId, itemId) : String.format("_api/web/lists/getbytitle('%s')/Items(%s)", this.encodeTitle(listId), itemId);
        this.delete(path);
    }

    @Override
    public Map<String, Object> attachFile(String listTitle, String itemId, String filePath, InputStream content) {
        String path = String.format("_api/web/lists/getbytitle('%s')/items('%s')/AttachmentFiles", listTitle, itemId) + "/add(FileName='" + Paths.get(filePath, new String[0]).getFileName() + "')";
        String url = this.getPath("", path);
        SharePointAttachResultJson result = this.addBlob(url, (HttpEntity)new SharepointBlobEntity(content), SharePointAttachResultJson.class, false);
        if (result != null) {
            return result.getResult();
        }
        return new HashMap<String, Object>();
    }

    @Override
    public void updateListItem(String listId, String itemId, Map<String, Object> updatedProperties) {
        ItemPropertyMapper itemPropertyMapper = new ItemPropertyMapper(new MetadataManager(this));
        Map<String, Object> updatedFields = itemPropertyMapper.mapItemIn(listId, updatedProperties, null);
        if (updatedFields == null) {
            throw new SharepointException("Update fields are missing for ITEM with ID " + itemId + " from LIST with ID " + listId, null);
        }
        com.mulesoft.connectors.sharepoint.api.output.SharepointList list = this.getList(listId, SELECT);
        updatedFields.put("__metadata", this.getTypeMap("type", list.getListItemEntityTypeFullName()));
        String path = this.isGuid(listId) ? String.format("_api/web/lists(guid'%s')/Items(%s)", listId, itemId) : String.format("_api/web/lists/getbytitle('%s')/Items(%s)", this.encodeTitle(listId), itemId);
        this.update(path, updatedFields, null);
    }

    @Override
    public SharepointFolder createFolder(String url, String welcomePage) {
        HashMap<String, Object> metadata = new HashMap<String, Object>();
        metadata.put("type", "SP.Folder");
        SharepointFolder folder = new SharepointFolder.SharepointFolderBuilder().setWelcomePage(welcomePage).setServerRelativeUrl(url).setMetadata(metadata).build();
        SharepointFolderJson resultInput = this.modelMapper.map(folder, SharepointFolderJson.class);
        SharepointFolderJson jsonOutput = this.postForObject("_api/web/folders", resultInput, SharepointFolderJson.class, true);
        return this.modelMapper.map(jsonOutput, SharepointFolder.SharepointFolderBuilder.class).build();
    }

    @Override
    public SharepointFolder getFolder(String serverRelativeUrl) {
        String path = this.getPath("", String.format("_api/web/GetFolderByServerRelativeUrl('%s')", serverRelativeUrl));
        SharepointFolderJson jsonOutput = this.getForObject(path, SharepointFolderJson.class, true);
        return this.modelMapper.map(jsonOutput, SharepointFolder.SharepointFolderBuilder.class).build();
    }

    private SharepointListItem listItemAllFields(String fileRelativeUrl) {
        String path = this.getPath("", String.format("_api/Web/GetFileByServerRelativeUrl('/%s')/ListItemAllFields", fileRelativeUrl));
        SharepointListItemJson jsonOutput = this.getForObject(path, SharepointListItemJson.class, true);
        return this.modelMapper.map(jsonOutput, SharepointListItem.class);
    }

    @Override
    public void deleteFolder(String serverRelativeUrl) {
        String path = this.getPath("", String.format("_api/web/GetFolderByServerRelativeUrl('%s')", serverRelativeUrl));
        this.delete(path);
    }

    @Override
    public List<Map<String, Object>> queryFolders(String query, String folderPath, boolean recursive) {
        String parsedFolderPath = ConnectorUtils.removeEnd(folderPath, "/");
        String expandedQuery = SharepointUtils.extractQueryString(query);
        String path = this.getPath(expandedQuery, String.format("_api/web/GetFolderByServerRelativeUrl('%s')/Folders", parsedFolderPath));
        List<Map<String, Object>> results = this.getForObject(path, SharepointFolderResultsJson.class, true).getResults();
        if (recursive) {
            ArrayList<Map<String, Object>> recursiveFolders = new ArrayList<Map<String, Object>>();
            for (Map<String, Object> folder : results) {
                recursiveFolders.addAll(this.queryFolders(expandedQuery, this.getServerRelativeUrlFromMetadata(folder), recursive));
            }
            results.addAll(recursiveFolders);
        }
        return results;
    }

    private List<Map<String, Object>> queryForFilesInFoldersUsingCamlQuery(String folderPath, String listId) {
        String parsedFolderPath = ConnectorUtils.removeEnd(folderPath, "/");
        UriBuilder uri = UriBuilder.fromUri((String)String.format("_api/web/lists(guid'%s')/getitems(query=@q1)", listId)).queryParam("$expand", new Object[]{"File"}).queryParam("@q1", new Object[]{UriComponent.encode((String)String.format("{\"FolderServerRelativeUrl\" : \"('%s')\", \"ViewXml\":\"<View Scope='Recursive'></View>\"}", parsedFolderPath), (UriComponent.Type)UriComponent.Type.QUERY_PARAM_SPACE_ENCODED)});
        String path = uri.build(new Object[0]).toString();
        SharepointFileResultsJson json = this.postForObject(path, null, SharepointFileResultsJson.class, true);
        List<Object> files = json == null ? Collections.emptyList() : json.getResults();
        LinkedList<Map<String, Object>> filteredFiles = new LinkedList<Map<String, Object>>();
        for (Map map : files) {
            Map fileInfo = (Map)map.get("File");
            if (fileInfo.get("__metadata") == null || !((Map)fileInfo.get("__metadata")).get("type").toString().equalsIgnoreCase("SP.File") || fileInfo.get(SERVER_RELATIVE_URL) == null || !fileInfo.get(SERVER_RELATIVE_URL).toString().contains(folderPath)) continue;
            filteredFiles.add(fileInfo);
        }
        return filteredFiles;
    }

    private <T> T addBlob(String url, HttpEntity entity, Class<T> clazz, boolean unwrapConfig) {
        HttpPost httpPost = new HttpPost(this.getAbsoluteUri(url));
        httpPost.setEntity(entity);
        httpPost.addHeader(X_REQUEST_DIGEST, this.getFormDigestValue());
        httpPost.addHeader("binaryStringRequestBody", "true");
        httpPost.addHeader("accept", ACCEPT_VALUE);
        return this.executeHttp((HttpUriRequest)httpPost, clazz, unwrapConfig);
    }

    @Override
    public SharepointFile addFile(String fileServerRelativeUrl, InputStream content, boolean overwrite) {
        String folderPath = FilenameUtils.getFullPath((String)fileServerRelativeUrl);
        String filename = FilenameUtils.getName((String)fileServerRelativeUrl);
        String path = String.format("/add(overwrite=%b,url='%s')", overwrite, filename);
        String url = this.getPath("", String.format(FILE_COLLECTION_URL, folderPath) + path);
        SharepointFileJson fileJson = this.addBlob(url, (HttpEntity)new SharepointBlobEntity(content), SharepointFileJson.class, true);
        return this.modelMapper.map(fileJson, SharepointFile.SharepointFileBuilder.class).build();
    }

    @Override
    public SharepointFile getFileMetadata(String fileServerRelativeUrl) {
        String folderPath = FilenameUtils.getFullPath((String)fileServerRelativeUrl);
        String filename = FilenameUtils.getName((String)fileServerRelativeUrl);
        return this.getFileMetadataWithQuery(filename, folderPath, null);
    }

    @Override
    public SharepointFile getFileMetadataWithQuery(String filename, String folderPath, String query) {
        String path = this.getPath(query, String.format(FILE_COLLECTION_URL, folderPath) + "('" + filename + "')");
        SharepointFileJson jsonOutput = this.getForObject(path, SharepointFileJson.class, true);
        return this.modelMapper.map(jsonOutput, SharepointFile.SharepointFileBuilder.class).build();
    }

    @Override
    public void deleteFile(String fileServerRelativeUrl) {
        if (StringUtils.isBlank((String)fileServerRelativeUrl)) {
            throw new ModuleException("'File  server relative url' parameter cannot be empty!", (ErrorTypeDefinition)SharepointErrorType.INVALID_PARAMETERS);
        }
        String folderPath = FilenameUtils.getFullPath((String)fileServerRelativeUrl);
        String filename = FilenameUtils.getName((String)fileServerRelativeUrl);
        String path = this.getPath("", String.format(FILE_COLLECTION_URL, folderPath) + "('" + filename + "')");
        this.delete(path);
    }

    @Override
    public InputStream getFileContent(String fileServerRelativeUrl) {
        String folderPath = FilenameUtils.getFullPath((String)fileServerRelativeUrl);
        String filename = FilenameUtils.getName((String)fileServerRelativeUrl);
        String path = this.getPath("", String.format(FILE_COLLECTION_URL, folderPath) + "('" + filename + "')/$value");
        return this.getForObject(path, InputStream.class, true);
    }

    @Override
    public void checkoutFile(String fileServerRelativeUrl) {
        String folderPath = FilenameUtils.getFullPath((String)fileServerRelativeUrl);
        String filename = FilenameUtils.getName((String)fileServerRelativeUrl);
        String path = this.getPath("", String.format(FILE_COLLECTION_URL, folderPath) + "('" + filename + "')/checkout");
        this.postForObject(path, null, null, false);
    }

    @Override
    public void checkInFile(String fileServerRelativeUrl, String checkInType, String comment) {
        String folderPath = FilenameUtils.getFullPath((String)fileServerRelativeUrl);
        String filename = FilenameUtils.getName((String)fileServerRelativeUrl);
        String path = this.getPath("", String.format(FILE_COLLECTION_URL, folderPath) + "('" + filename + "')/checkin(comment='" + comment + "',checkintype=" + checkInType + ")");
        this.postForObject(path, null, null, false);
    }

    @Override
    public void undoCheckOut(String fileServerRelativeUrl) {
        String folderPath = FilenameUtils.getFullPath((String)fileServerRelativeUrl);
        String filename = FilenameUtils.getName((String)fileServerRelativeUrl);
        String path = this.getPath("", String.format(FILE_COLLECTION_URL, folderPath) + "('" + filename + "')/undocheckout");
        this.postForObject(path, null, null, false);
    }

    @Override
    public void publishFile(String fileServerRelativeUrl, String comment) {
        String folderPath = FilenameUtils.getFullPath((String)fileServerRelativeUrl);
        String filename = FilenameUtils.getName((String)fileServerRelativeUrl);
        String path = this.getPath("", String.format(FILE_COLLECTION_URL, folderPath) + "('" + filename + "')/publish(comment='" + comment + "')");
        this.postForObject(path, null, null, false);
    }

    @Override
    public void unpublishFile(String fileServerRelativeUrl, String comment) {
        String folderPath = FilenameUtils.getFullPath((String)fileServerRelativeUrl);
        String filename = FilenameUtils.getName((String)fileServerRelativeUrl);
        String path = this.getPath("", String.format(FILE_COLLECTION_URL, folderPath) + "('" + filename + "')/unpublish(comment='" + comment + "')");
        this.postForObject(path, null, null, false);
    }

    @Override
    public void approveFile(String fileServerRelativeUrl, String comment) {
        String folderPath = FilenameUtils.getFullPath((String)fileServerRelativeUrl);
        String filename = FilenameUtils.getName((String)fileServerRelativeUrl);
        String path = this.getPath("", String.format(FILE_COLLECTION_URL, folderPath) + "('" + filename + "')/approve(comment='" + comment + "')");
        this.postForObject(path, null, null, false);
    }

    @Override
    public void denyFile(String fileServerRelativeUrl, String comment) {
        String folderPath = FilenameUtils.getFullPath((String)fileServerRelativeUrl);
        String filename = FilenameUtils.getName((String)fileServerRelativeUrl);
        String path = this.getPath("", String.format(FILE_COLLECTION_URL, folderPath) + "('" + filename + "')/deny(comment='" + comment + "')");
        this.postForObject(path, null, null, false);
    }

    @Override
    public List<Map<String, Object>> queryFile(String query, String parsedFolderPath, boolean recursive) {
        String path = this.getPath(query, String.format(FILE_COLLECTION_URL, parsedFolderPath));
        List<Map<String, Object>> results = this.getForObject(path, SharepointFileResultsJson.class, true).getResults();
        if (recursive) {
            List<Map<String, Object>> folders = this.queryFolders("", parsedFolderPath, true);
            for (Map<String, Object> folder : folders) {
                path = this.getPath(query, String.format(FILE_COLLECTION_URL, this.getServerRelativeUrlFromMetadata(folder)));
                SharepointFileResultsJson jsonOutput = this.getForObject(path, SharepointFileResultsJson.class, true);
                results.addAll(this.modelMapper.map(jsonOutput, SharepointFileResults.class).getResults());
            }
        }
        return results;
    }

    @Override
    public List<Map<String, Object>> queryForFilesInFolders(String query, String parsedFolderPath, boolean recursive, String listId, String watermarkField, String since) {
        List<Map<String, Object>> filesFromFolders;
        String path = this.getPath(query, String.format(FILE_COLLECTION_URL, parsedFolderPath));
        if (recursive) {
            if (listId != null) {
                filesFromFolders = new ArrayList<Map<String, Object>>(this.queryForFilesInFoldersUsingCamlQuery(parsedFolderPath, listId));
            } else {
                filesFromFolders = this.getForObject(path, SharepointFileResultsJson.class, true).getResults();
                List<Map<String, Object>> folders = this.queryFolders("", parsedFolderPath, true);
                for (Map<String, Object> folder : folders) {
                    path = this.getPath(query, String.format(FILE_COLLECTION_URL, this.getServerRelativeUrlFromMetadata(folder)));
                    SharepointFileResultsJson jsonOutput = this.getForObject(path, SharepointFileResultsJson.class, true);
                    filesFromFolders.addAll(this.modelMapper.map(jsonOutput, SharepointFileResults.class).getResults());
                }
            }
        } else {
            filesFromFolders = this.getForObject(path, SharepointFileResultsJson.class, true).getResults();
        }
        return filesFromFolders;
    }

    @Override
    public void copyFileTo(String fileServerRelativeUrl, String newFilePath, boolean overwrite) {
        String folderPath = FilenameUtils.getFullPath((String)fileServerRelativeUrl);
        String filename = FilenameUtils.getName((String)fileServerRelativeUrl);
        String path = this.getPath("", String.format(FILE_COLLECTION_URL, folderPath) + "('" + filename + "')/copyto(strnewurl='" + newFilePath + "',boverwrite=" + overwrite + ")");
        this.postForObject(path, null, null, false);
    }

    @Override
    public String recycleFile(String fileServerRelativeUrl) {
        String folderPath = FilenameUtils.getFullPath((String)fileServerRelativeUrl);
        String filename = FilenameUtils.getName((String)fileServerRelativeUrl);
        String path = this.getPath("", String.format(FILE_COLLECTION_URL, folderPath) + "('" + filename + "')/recycle");
        RecycleFileJson json = this.postForObject(path, null, RecycleFileJson.class, true);
        return json == null ? null : json.getRecycle();
    }

    @Override
    public Map<String, Object> resolveObject(String url, ResolveRequestType resolveRequestType, Object body) {
        if (resolveRequestType == ResolveRequestType.Create && (body instanceof InputStream || body instanceof byte[])) {
            InputStream input = body instanceof byte[] ? new ByteArrayInputStream((byte[])body) : (InputStream)body;
            this.resolveMapResult(url, (HttpEntity)new SharepointBlobEntity(input)).getResult();
        }
        switch (resolveRequestType) {
            case Get: {
                return this.resolveObject(url);
            }
            case Create: {
                return this.resolveCreate(url, body);
            }
            case Merge: {
                this.resolveUpdate(url, body);
                return null;
            }
            case Delete: {
                this.resolveDelete(url);
                return null;
            }
        }
        throw new SharepointException("Unknown ResolveRequestType", null);
    }

    private Map<String, Object> resolveObject(String url) {
        SharepointMapResultJson sharepointObject = this.getForObject(url, SharepointMapResultJson.class, true);
        return sharepointObject.getResult();
    }

    @Override
    public List<Map<String, Object>> resolveCollection(String url) {
        try {
            SharepointListOfMapResultJson sharepointObject = this.getForObject(url, SharepointListOfMapResultJson.class, true);
            return sharepointObject.getResults();
        }
        catch (SharepointException ex) {
            String jsonResponse = this.getForObject(url, String.class, true);
            try {
                return this.objectMapper.map(jsonResponse, SharePointListResultJson.class).getResults();
            }
            catch (Exception e) {
                throw new SharepointException(e.getMessage(), e);
            }
        }
    }

    private Map<String, Object> resolveCreate(String url, Object body) {
        SharepointMapResultJson json = this.postForObject(url, body, SharepointMapResultJson.class, true);
        return json == null ? Collections.emptyMap() : json.getResult();
    }

    private void resolveUpdate(String url, Object body) {
        this.update(url, body, null);
    }

    private void resolveDelete(String url) {
        this.delete(url);
    }

    @Override
    public <T> T resolvePost(String url, Object body, Class<T> clazz) {
        return this.postForObject(url, body, clazz, true);
    }

    protected String getServerRelativeUrlFromMetadata(Map<String, Object> folder) {
        Map metadata = (Map)folder.get("__metadata");
        String metadataId = metadata.get("id").toString();
        return ConnectorUtils.substringBefore(ConnectorUtils.substringAfterLast(metadataId, "GetFolderByServerRelativeUrl('"), "')");
    }

    private boolean isGuid(String id) {
        return id != null && id.matches("(?i)[0-9a-f]{8}-[0-9a-f]{4}-[1-5][0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}");
    }

    @Override
    public SharepointListItem getAllItemFields(String fileServerRelativeUrl, Map<String, Object> updatedProperties) {
        if (updatedProperties == null) {
            throw new SharepointException("Properties to be updated are missing for file: " + fileServerRelativeUrl, null);
        }
        return this.listItemAllFields(fileServerRelativeUrl);
    }

    @Override
    public void updateFileMetadata(SharepointListItem file, Map<String, Object> updatedProperties) {
        if (file.getProperties().get("__metadata") == null) {
            throw new SharepointException("Cannot update this file Metadata. This file is not represented by an item from a document library.", null);
        }
        Map listItemMetadata = (Map)file.getProperties().get("__metadata");
        String fileURI = (String)listItemMetadata.get("uri");
        String listType = (String)listItemMetadata.get("type");
        String itemId = file.getId();
        String listId = fileURI.substring(fileURI.indexOf("(guid'") + 6, fileURI.indexOf("')"));
        updatedProperties.put("__metadata", this.getTypeMap("type", listType));
        String path = this.isGuid(listId) ? String.format("_api/web/lists(guid'%s')/Items(%s)", listId, itemId) : String.format("_api/web/lists/getbytitle('%s')/Items(%s)", this.encodeTitle(listId), itemId);
        this.update(path, updatedProperties, null);
    }

    private SharepointMapResult resolveMapResult(String url, HttpEntity entity) {
        SharepointMapResultJson jsonOutput = this.addBlob(url, entity, SharepointMapResultJson.class, true);
        return this.modelMapper.map(jsonOutput, SharepointMapResult.class);
    }

    @Override
    public SharepointListItemResults getPage(String pageUrl) {
        SharepointListItemResultsJson jsonOutput = this.getForObject(pageUrl, SharepointListItemResultsJson.class, true);
        return this.modelMapper.map(jsonOutput, SharepointListItemResults.class);
    }

    private String encodeTitle(String title) {
        if (ConnectorUtils.isEmpty(title)) {
            return title;
        }
        try {
            return URLEncoder.encode(title, this.encodingCharset.getCharset());
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public <T> T getForObject(String path, Class<T> clazz, boolean unwrapConfig) {
        if (clazz == byte[].class) {
            return this.getBytesWithoutFailingWhenInvalidContentTypeIsReturned(path);
        }
        HttpGet httpGet = new HttpGet(this.getAbsoluteUri(path));
        httpGet.setHeader((Header)new BasicHeader(CONTENT_TYPE, CONTENT_TYPE_VALUE + (Object)((Object)this.encodingCharset)));
        httpGet.setHeader((Header)new BasicHeader(ACCEPT, ACCEPT_VALUE));
        return this.executeHttp((HttpUriRequest)httpGet, clazz, unwrapConfig);
    }

    @Override
    public void moveFileTo(String fileServerRelativeUrl, String newFilePath, int flag) {
        String folderPath = FilenameUtils.getFullPath((String)fileServerRelativeUrl);
        String filename = FilenameUtils.getName((String)fileServerRelativeUrl);
        String path = this.getPath("", String.format(FILE_COLLECTION_URL, folderPath) + "('" + filename + "')/moveto(newurl='" + newFilePath + "',flags=" + flag + ")");
        this.postForObject(path, null, null, false);
    }

    private <T> T postForObject(String path, Object object, Class<T> clazz, boolean unwrapConfig) {
        HttpPost httpPost = new HttpPost(this.getAbsoluteUri(path));
        httpPost.setHeader((Header)new BasicHeader(IF_MATCH, "*"));
        httpPost.setHeader((Header)new BasicHeader(CONTENT_TYPE, CONTENT_TYPE_VALUE + (Object)((Object)this.encodingCharset)));
        httpPost.setHeader((Header)new BasicHeader(ACCEPT, ACCEPT_VALUE));
        httpPost.setHeader((Header)new BasicHeader(X_REQUEST_DIGEST, this.getFormDigestValue()));
        if (object != null) {
            ByteArrayEntity httpEntity = new ByteArrayEntity(this.objectToJsonString(object).getBytes());
            httpPost.setEntity((HttpEntity)httpEntity);
        }
        return this.executeHttp((HttpUriRequest)httpPost, clazz, unwrapConfig);
    }

    @Nullable
    private <T> T executeHttp(HttpUriRequest request, Class<T> clazz, boolean unwrapConfig) {
        ByteArrayInputStream obj = null;
        String response = null;
        if (logger.isDebugEnabled()) {
            logger.debug("Executing request: {} at URI: {}", (Object)request.getMethod(), (Object)request.getURI());
        }
        CloseableHttpResponse httpResponse = this.sendRequestAndHandleStatusCode(request);
        try {
            if (clazz != null) {
                this.objectMapper.configureDeserialization(DeserializationFeature.UNWRAP_ROOT_VALUE, unwrapConfig);
                response = EntityUtils.toString((HttpEntity)httpResponse.getEntity());
                obj = clazz == InputStream.class ? new ByteArrayInputStream(response.getBytes()) : this.objectMapper.map(response, clazz);
            }
        }
        catch (Exception e) {
            throw new SharepointException(e.getMessage(), e);
        }
        finally {
            EntityUtils.consumeQuietly((HttpEntity)httpResponse.getEntity());
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Response received:{} for request: {} at URI{}", new Object[]{response, request.getMethod(), request.getURI()});
        }
        return (T)obj;
    }

    private CloseableHttpResponse sendRequestAndHandleStatusCode(HttpUriRequest request) {
        CloseableHttpResponse httpResponse;
        this.headers.forEach((arg_0, arg_1) -> ((HttpUriRequest)request).setHeader(arg_0, arg_1));
        try {
            httpResponse = this.httpClient.execute(request, this.httpContext);
        }
        catch (IOException e) {
            logger.warn("Failed to execute request: {}", (Object)request);
            throw new SharepointException(e.getMessage(), e);
        }
        int statusCode = httpResponse.getStatusLine().getStatusCode();
        if (statusCode >= 500) {
            String message = this.getResponseBody(httpResponse);
            logger.warn("Internal server error: {}", (Object)message);
            throw new InternalServerException(CODE + statusCode + MESSAGE + message, (Exception)new HttpResponseException(statusCode, message));
        }
        if (statusCode >= 400) {
            String message = this.getResponseBody(httpResponse);
            logger.warn("Bad request: {}", (Object)message);
            throw new UnableToSendException(CODE + statusCode + MESSAGE + message, (Exception)new HttpResponseException(statusCode, message));
        }
        return httpResponse;
    }

    private String getResponseBody(CloseableHttpResponse httpResponse) {
        try {
            return EntityUtils.toString((HttpEntity)httpResponse.getEntity());
        }
        catch (IOException e) {
            throw new SharepointException(e.getMessage(), e);
        }
    }

    protected void delete(String path) {
        HttpDelete httpDelete = new HttpDelete(this.getAbsoluteUri(path));
        httpDelete.setHeader((Header)new BasicHeader(CONTENT_TYPE, CONTENT_TYPE_VALUE + (Object)((Object)this.encodingCharset)));
        httpDelete.setHeader((Header)new BasicHeader(ACCEPT, ACCEPT_VALUE));
        httpDelete.setHeader((Header)new BasicHeader(IF_MATCH, "*"));
        httpDelete.setHeader((Header)new BasicHeader("X-HTTP-Method", "DELETE"));
        httpDelete.setHeader((Header)new BasicHeader(X_REQUEST_DIGEST, this.getFormDigestValue()));
        this.executeHttp((HttpUriRequest)httpDelete, null, false);
    }

    protected <T> T update(String path, Object updatedFields, Class<T> clazz) {
        HttpPost httpPost = new HttpPost(this.getAbsoluteUri(path));
        httpPost.setHeader((Header)new BasicHeader(IF_MATCH, "*"));
        httpPost.setHeader((Header)new BasicHeader("X-HTTP-Method", "MERGE"));
        httpPost.setHeader((Header)new BasicHeader(CONTENT_TYPE, CONTENT_TYPE_VALUE + (Object)((Object)this.encodingCharset)));
        httpPost.setHeader((Header)new BasicHeader(ACCEPT, ACCEPT_VALUE));
        httpPost.setHeader((Header)new BasicHeader(X_REQUEST_DIGEST, this.getFormDigestValue()));
        if (updatedFields != null) {
            ByteArrayEntity httpEntity = new ByteArrayEntity(this.objectToJsonString(updatedFields).getBytes());
            httpPost.setEntity((HttpEntity)httpEntity);
        }
        return this.executeHttp((HttpUriRequest)httpPost, clazz, true);
    }

    private URI getAbsoluteUri(String path) {
        URI uri;
        try {
            uri = new URI(path);
            if (!uri.isAbsolute()) {
                uri = new URI(this.siteUrl + path);
            }
        }
        catch (URISyntaxException e) {
            throw new SharepointException(e.getMessage(), e);
        }
        return uri;
    }

    private String objectToJsonString(Object object) {
        if (object instanceof String) {
            return (String)object;
        }
        try {
            return this.objectMapper.asString(object);
        }
        catch (JsonProcessingException e) {
            throw new SharepointException(e.getMessage(), e);
        }
    }

    private <T> T getBytesWithoutFailingWhenInvalidContentTypeIsReturned(String path) {
        URI uri;
        try {
            uri = new URI(this.siteUrl + path);
        }
        catch (URISyntaxException e) {
            throw new SharepointException(e.getMessage(), e);
        }
        HttpGet request = new HttpGet(uri);
        request.addHeader((Header)new BasicHeader("Content-Length", Long.toString(0L)));
        request.addHeader((Header)new BasicHeader(ACCEPT, "application/octet-stream"));
        CloseableHttpResponse httpResponse = this.sendRequestAndHandleStatusCode((HttpUriRequest)request);
        try {
            byte[] bytes = IOUtils.toByteArray((InputStream)httpResponse.getEntity().getContent());
            return (T)bytes;
        }
        catch (Exception e) {
            throw new SharepointException(e.getMessage(), e);
        }
    }

    private String updateQuerySkippedEncodeCharacter(String newUri) {
        String[] queryParams = SharepointUtils.extractQueryString(newUri).split("&");
        ArrayList<String> updatedQueryParams = new ArrayList<String>();
        for (String queryParam : queryParams) {
            if (updatedQueryParams.isEmpty()) {
                updatedQueryParams.add(queryParam);
                continue;
            }
            if (queryParam.startsWith("$")) {
                updatedQueryParams.add("&" + queryParam);
                continue;
            }
            String lastElement = (String)updatedQueryParams.get(updatedQueryParams.size() - 1);
            updatedQueryParams.add(lastElement + AND_ENCODED_CHARACTER + queryParam);
            updatedQueryParams.remove(lastElement);
        }
        return SharepointUtils.extractPath(newUri) + "?" + String.join((CharSequence)"", updatedQueryParams);
    }
}

