/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.sharepoint.internal.service;

import com.mulesoft.connectors.sharepoint.internal.config.SharepointConfiguration;
import com.mulesoft.connectors.sharepoint.internal.connection.OAuthSharepointConnection;
import com.mulesoft.connectors.sharepoint.internal.connection.SharepointConnection;
import com.mulesoft.connectors.sharepoint.internal.error.SharepointErrorType;
import com.mulesoft.connectors.sharepoint.internal.service.SharepointService;
import com.mulesoft.connectors.sharepoint.internal.service.proxy.HttpClientContextPair;
import com.mulesoft.connectors.sharepoint.internal.service.proxy.SharepointClientProxyFactory;
import com.mulesoft.connectors.sharepoint.internal.service.utils.ClientType;
import java.net.URL;
import java.util.HashMap;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;

public class SharepointServiceFactory {
    private static final Object lock = new Object();
    private static SharepointServiceFactory instance;

    private SharepointServiceFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized SharepointServiceFactory getInstance() {
        if (instance == null) {
            Object object = lock;
            synchronized (object) {
                if (instance == null) {
                    instance = new SharepointServiceFactory();
                }
            }
        }
        return instance;
    }

    public SharepointService getClient(SharepointConfiguration sharepointConfiguration, SharepointConnection connection) {
        URL serviceURL = connection.getServiceURL();
        HttpClientContextPair httpClientContextPair = connection.getHttpClientContextPair();
        HashMap<String, String> headers = new HashMap<String, String>();
        if (connection instanceof OAuthSharepointConnection) {
            headers.put("Authorization", "Bearer " + ((OAuthSharepointConnection)connection).getAccessToken());
        }
        try {
            ClientType clientType = sharepointConfiguration.getClientType();
            return SharepointClientProxyFactory.getProxy(sharepointConfiguration.getEncodingCharset(), clientType, serviceURL, httpClientContextPair, headers);
        }
        catch (Exception e) {
            throw new ModuleException(e.getMessage(), (ErrorTypeDefinition)SharepointErrorType.UNKNOWN, (Throwable)e);
        }
    }
}

