/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.sharepoint.internal.operation;

import com.google.common.collect.Lists;
import com.mulesoft.connectors.sharepoint.api.CheckInType;
import com.mulesoft.connectors.sharepoint.api.ResolveRequestType;
import com.mulesoft.connectors.sharepoint.api.output.SharepointFile;
import com.mulesoft.connectors.sharepoint.api.output.SharepointFolder;
import com.mulesoft.connectors.sharepoint.api.output.SharepointList;
import com.mulesoft.connectors.sharepoint.internal.config.SharepointConfiguration;
import com.mulesoft.connectors.sharepoint.internal.connection.SharepointConnection;
import com.mulesoft.connectors.sharepoint.internal.error.provider.SharepointErrorTypeProvider;
import com.mulesoft.connectors.sharepoint.internal.metadata.specialist.operations.CollectionMetadataResolver;
import com.mulesoft.connectors.sharepoint.internal.metadata.specialist.operations.FileMetadataResolver;
import com.mulesoft.connectors.sharepoint.internal.metadata.specialist.operations.FolderMetadataResolver;
import com.mulesoft.connectors.sharepoint.internal.metadata.specialist.operations.ListMetadataResolver;
import com.mulesoft.connectors.sharepoint.internal.metadata.specialist.operations.NativeFileQueryMetadataResolver;
import com.mulesoft.connectors.sharepoint.internal.metadata.specialist.operations.NativeFolderQueryMetadataResolver;
import com.mulesoft.connectors.sharepoint.internal.metadata.specialist.operations.NativeListQueryMetadataResolver;
import com.mulesoft.connectors.sharepoint.internal.metadata.specialist.operations.ObjectMetadataResolver;
import com.mulesoft.connectors.sharepoint.internal.metadata.specialist.operations.SharepointQueryTranslator;
import com.mulesoft.connectors.sharepoint.internal.paging.SharepointPagingProvider;
import com.mulesoft.connectors.sharepoint.internal.service.SharepointService;
import com.mulesoft.connectors.sharepoint.internal.service.SharepointServiceFactory;
import com.mulesoft.connectors.sharepoint.internal.service.mapping.entity.SharepointListItem;
import com.mulesoft.connectors.sharepoint.internal.utils.ConnectorUtils;
import com.mulesoft.connectors.sharepoint.internal.utils.ODataHelper;
import com.mulesoft.connectors.sharepoint.internal.utils.SharepointUtils;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.metadata.MetadataKeyId;
import org.mule.runtime.extension.api.annotation.metadata.OutputResolver;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.Content;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.NullSafe;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Query;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Text;
import org.mule.runtime.extension.api.runtime.streaming.PagingProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Throws(value={SharepointErrorTypeProvider.class})
public class SharepointOperations {
    private static final Logger logger = LoggerFactory.getLogger(SharepointOperations.class);

    public SharepointFolder folderCreate(@Config SharepointConfiguration config, @Connection SharepointConnection connection, @Optional String url, @Optional String welcomePage) {
        if (logger.isDebugEnabled()) {
            logger.debug("Calling folder create with url: {} and welcomePage: {}", (Object)url, (Object)welcomePage);
        }
        return connection.execute(() -> SharepointServiceFactory.getInstance().getClient(config, connection).createFolder(url, welcomePage));
    }

    @Throws(value={SharepointErrorTypeProvider.class})
    public void folderDelete(@Config SharepointConfiguration config, @Connection SharepointConnection connection, @Optional String url) {
        if (logger.isDebugEnabled()) {
            logger.debug("Calling folder delete with url: {} ", (Object)url);
        }
        connection.execute(() -> {
            SharepointServiceFactory.getInstance().getClient(config, connection).deleteFolder(url);
            return null;
        });
    }

    @Query(translator=SharepointQueryTranslator.DummyQueryTranslator.class, entityResolver=FolderMetadataResolver.class, nativeOutputResolver=NativeFolderQueryMetadataResolver.class)
    public List<Map<String, Object>> folderQuery(@Config SharepointConfiguration config, @Connection SharepointConnection connection, @Text @MetadataKeyId String query, @Optional(defaultValue="/") String startingFolderPath, @Optional(defaultValue="false") boolean recursive) {
        if (logger.isDebugEnabled()) {
            logger.debug("Calling folder query with query: {} starting folder path: {} and recursive: {}", new Object[]{query, startingFolderPath, recursive});
        }
        SharepointService service = SharepointServiceFactory.getInstance().getClient(config, connection);
        query = SharepointUtils.translateDsqlQuery(service, query);
        query = SharepointQueryTranslator.keepOnlyOriginalIfMapped(query);
        String expandedQuery = ODataHelper.expandIfNecessary(query, Lists.newArrayList((Object[])new String[]{"Files", "ListItemAllFields", "ParentFolder", "Properties", "Folders"}));
        String queryList = ConnectorUtils.removeEnd(SharepointUtils.extractPath(expandedQuery), "_F");
        return connection.execute(() -> SharepointServiceFactory.getInstance().getClient(config, connection).queryFolders(expandedQuery, queryList + startingFolderPath, recursive));
    }

    public SharepointList listCreate(@Config SharepointConfiguration config, @Connection SharepointConnection connection, @Content @Optional com.mulesoft.connectors.sharepoint.api.SharepointList list) {
        if (logger.isDebugEnabled()) {
            logger.debug("Calling list create with Sharepoint list: {}", (Object)list);
        }
        return connection.execute(() -> SharepointServiceFactory.getInstance().getClient(config, connection).createList(list));
    }

    public void listUpdate(@Config SharepointConfiguration config, @Connection SharepointConnection connection, String listId, @Content @Optional com.mulesoft.connectors.sharepoint.api.SharepointList list) {
        if (logger.isDebugEnabled()) {
            logger.debug("Calling list update with list id: {} and Sharepoint list: {}", (Object)listId, (Object)list);
        }
        connection.execute(() -> {
            SharepointServiceFactory.getInstance().getClient(config, connection).updateList(listId, list);
            return null;
        });
    }

    public void listDelete(@Config SharepointConfiguration config, @Connection SharepointConnection connection, String listId) {
        if (logger.isDebugEnabled()) {
            logger.debug("Calling list delete with list id: {}", (Object)listId);
        }
        connection.execute(() -> {
            SharepointServiceFactory.getInstance().getClient(config, connection).deleteList(listId);
            return null;
        });
    }

    public SharepointList listGet(@Config SharepointConfiguration config, @Connection SharepointConnection connection, String listId) {
        if (logger.isDebugEnabled()) {
            logger.debug("Calling list get with list id: {}", (Object)listId);
        }
        return connection.execute(() -> SharepointServiceFactory.getInstance().getClient(config, connection).getList(listId, ""));
    }

    public List<SharepointList> listGetAll(@Config SharepointConfiguration config, @Connection SharepointConnection connection) {
        if (logger.isDebugEnabled()) {
            logger.debug("Calling list get all");
        }
        return connection.execute(() -> SharepointServiceFactory.getInstance().getClient(config, connection).getLists(""));
    }

    @OutputResolver(output=ListMetadataResolver.class)
    public Map<String, Object> listItemCreate(@Config SharepointConfiguration config, @Connection SharepointConnection connection, @MetadataKeyId String listId, @Content @Optional @NullSafe Map<String, Object> properties) {
        if (logger.isDebugEnabled()) {
            logger.debug("Calling list item create with list id: {} and properties: {}", (Object)listId, properties);
        }
        return connection.execute(() -> SharepointServiceFactory.getInstance().getClient(config, connection).createListItem(listId, properties));
    }

    public void listItemDelete(@Config SharepointConfiguration config, @Connection SharepointConnection connection, String listId, @Optional String itemId) {
        if (logger.isDebugEnabled()) {
            logger.debug("Calling list item delete with list id: {} and item id: {}", (Object)listId, (Object)itemId);
        }
        connection.execute(() -> {
            SharepointServiceFactory.getInstance().getClient(config, connection).deleteListItem(listId, itemId);
            return null;
        });
    }

    public void listItemUpdate(@Config SharepointConfiguration config, @Connection SharepointConnection connection, String listId, String itemId, @Content @Optional @NullSafe Map<String, Object> updatedProperties) {
        if (logger.isDebugEnabled()) {
            logger.debug("Calling list item update with list id: {} and item id: {} and updated properties: {}", new Object[]{listId, itemId, updatedProperties});
        }
        connection.execute(() -> {
            SharepointServiceFactory.getInstance().getClient(config, connection).updateListItem(listId, itemId, updatedProperties);
            return null;
        });
    }

    @OutputResolver(output=ListMetadataResolver.class)
    public Map<String, Object> attachFile(@Config SharepointConfiguration config, @Connection SharepointConnection connection, @MetadataKeyId String listTitle, String itemId, String fileName, @Content InputStream content) {
        if (logger.isDebugEnabled()) {
            logger.debug("Calling attach file with list title: {} item id: {} and filename: {}", new Object[]{listTitle, itemId, fileName});
        }
        return connection.execute(() -> SharepointServiceFactory.getInstance().getClient(config, connection).attachFile(listTitle, itemId, fileName, content));
    }

    @Query(translator=SharepointQueryTranslator.DummyQueryTranslator.class, entityResolver=ListMetadataResolver.class, nativeOutputResolver=NativeListQueryMetadataResolver.class)
    public PagingProvider<SharepointConnection, Map<String, Object>> listItemQuery(@Config SharepointConfiguration config, @MetadataKeyId @Text String query, @Optional(defaultValue="false") boolean retrieveReferences) {
        if (logger.isDebugEnabled()) {
            logger.debug("Calling list item query with query: {} and retrieve references: {}", (Object)query, (Object)retrieveReferences);
        }
        return new SharepointPagingProvider(query, retrieveReferences, config);
    }

    public SharepointFile fileAdd(@Config SharepointConfiguration config, @Connection SharepointConnection connection, String fileServerRelativeUrl, @Optional @Content InputStream fileContentStream, @Optional boolean overwrite) {
        if (logger.isDebugEnabled()) {
            logger.debug("Calling file add  with file server relative url: {} and overwrite: {}", (Object)fileServerRelativeUrl, (Object)overwrite);
        }
        return connection.execute(() -> SharepointServiceFactory.getInstance().getClient(config, connection).addFile(fileServerRelativeUrl, fileContentStream, overwrite));
    }

    public void fileDelete(@Config SharepointConfiguration config, @Connection SharepointConnection connection, String fileServerRelativeUrl) {
        if (logger.isDebugEnabled()) {
            logger.debug("Calling file delete with file server relative url: {}", (Object)fileServerRelativeUrl);
        }
        connection.execute(() -> {
            SharepointServiceFactory.getInstance().getClient(config, connection).deleteFile(fileServerRelativeUrl);
            return null;
        });
    }

    public SharepointFile getMetadata(@Config SharepointConfiguration config, @Connection SharepointConnection connection, String fileServerRelativeUrl) {
        if (logger.isDebugEnabled()) {
            logger.debug("Calling get metadata with file server relative url: {}", (Object)fileServerRelativeUrl);
        }
        return connection.execute(() -> SharepointServiceFactory.getInstance().getClient(config, connection).getFileMetadata(fileServerRelativeUrl));
    }

    public void fileUpdateMetadata(@Config SharepointConfiguration config, @Connection SharepointConnection connection, String fileServerRelativeUrl, @Content Map<String, Object> updateProperties) {
        if (logger.isDebugEnabled()) {
            logger.debug("Calling file update metadata with file server relative url: {} and update properties: {}", (Object)fileServerRelativeUrl, updateProperties);
        }
        SharepointListItem fileItem = connection.execute(() -> SharepointServiceFactory.getInstance().getClient(config, connection).getAllItemFields(fileServerRelativeUrl, updateProperties));
        connection.execute(() -> {
            SharepointServiceFactory.getInstance().getClient(config, connection).updateFileMetadata(fileItem, updateProperties);
            return null;
        });
    }

    @MediaType(value="*/*")
    public InputStream fileGetContent(@Config SharepointConfiguration config, @Connection SharepointConnection connection, String fileServerRelativeUrl) {
        if (logger.isDebugEnabled()) {
            logger.debug("Calling file get content with file server relative url: {}", (Object)fileServerRelativeUrl);
        }
        return connection.execute(() -> SharepointServiceFactory.getInstance().getClient(config, connection).getFileContent(fileServerRelativeUrl));
    }

    public void fileCheckOut(@Config SharepointConfiguration config, @Connection SharepointConnection connection, String fileServerRelativeUrl) {
        if (logger.isDebugEnabled()) {
            logger.debug("Calling file checkout with file server relative url: {}", (Object)fileServerRelativeUrl);
        }
        connection.execute(() -> {
            SharepointServiceFactory.getInstance().getClient(config, connection).checkoutFile(fileServerRelativeUrl);
            return null;
        });
    }

    public void fileUndoCheckOut(@Config SharepointConfiguration config, @Connection SharepointConnection connection, String fileServerRelativeUrl) {
        if (logger.isDebugEnabled()) {
            logger.debug("Calling file undo checkout with file server relative url: {}", (Object)fileServerRelativeUrl);
        }
        connection.execute(() -> {
            SharepointServiceFactory.getInstance().getClient(config, connection).undoCheckOut(fileServerRelativeUrl);
            return null;
        });
    }

    public void fileCheckIn(@Config SharepointConfiguration config, @Connection SharepointConnection connection, String fileServerRelativeUrl, CheckInType checkInType, String comment) {
        if (logger.isDebugEnabled()) {
            logger.debug("Calling file checkin with file server relative url: {} check in type: {} and comment: {}", new Object[]{fileServerRelativeUrl, checkInType, comment});
        }
        connection.execute(() -> {
            SharepointServiceFactory.getInstance().getClient(config, connection).checkInFile(fileServerRelativeUrl, checkInType.getValue(), comment);
            return null;
        });
    }

    public void filePublish(@Config SharepointConfiguration config, @Connection SharepointConnection connection, String fileServerRelativeUrl, @Optional String comment) {
        if (logger.isDebugEnabled()) {
            logger.debug("Calling file publish with file server relative url: {} and comment: {}", (Object)fileServerRelativeUrl, (Object)comment);
        }
        connection.execute(() -> {
            SharepointServiceFactory.getInstance().getClient(config, connection).publishFile(fileServerRelativeUrl, comment);
            return null;
        });
    }

    public void fileUnpublish(@Config SharepointConfiguration config, @Connection SharepointConnection connection, String fileServerRelativeUrl, @Optional String comment) {
        if (logger.isDebugEnabled()) {
            logger.debug("Calling file unpublish with file server relative url: {} and comment: {}", (Object)fileServerRelativeUrl, (Object)comment);
        }
        connection.execute(() -> {
            SharepointServiceFactory.getInstance().getClient(config, connection).unpublishFile(fileServerRelativeUrl, comment);
            return null;
        });
    }

    public void fileApprove(@Config SharepointConfiguration config, @Connection SharepointConnection connection, String fileServerRelativeUrl, @Optional String comment) {
        if (logger.isDebugEnabled()) {
            logger.debug("Calling file approve with file server relative url: {} and comment: {}", (Object)fileServerRelativeUrl, (Object)comment);
        }
        connection.execute(() -> {
            SharepointServiceFactory.getInstance().getClient(config, connection).approveFile(fileServerRelativeUrl, comment);
            return null;
        });
    }

    public void fileDeny(@Config SharepointConfiguration config, @Connection SharepointConnection connection, String fileServerRelativeUrl, @Optional String comment) {
        if (logger.isDebugEnabled()) {
            logger.debug("Calling file deny with file server relative url: {} and comment: {}", (Object)fileServerRelativeUrl, (Object)comment);
        }
        connection.execute(() -> {
            SharepointServiceFactory.getInstance().getClient(config, connection).denyFile(fileServerRelativeUrl, comment);
            return null;
        });
    }

    public void fileCopyTo(@Config SharepointConfiguration config, @Connection SharepointConnection connection, String fileServerRelativeUrl, String newFileServerRelativeUrl, boolean overwrite) {
        if (logger.isDebugEnabled()) {
            logger.debug("Calling file copy to with file server relative url: {} new file server relative url: {} and overwrite: {}", new Object[]{fileServerRelativeUrl, newFileServerRelativeUrl, overwrite});
        }
        connection.execute(() -> {
            SharepointServiceFactory.getInstance().getClient(config, connection).copyFileTo(fileServerRelativeUrl, newFileServerRelativeUrl, overwrite);
            return null;
        });
    }

    @MediaType(value="text/plain")
    public String fileRecycle(@Config SharepointConfiguration config, @Connection SharepointConnection connection, String fileServerRelativeUrl) {
        if (logger.isDebugEnabled()) {
            logger.debug("Calling file recycle with file server relative url: {}", (Object)fileServerRelativeUrl);
        }
        return connection.execute(() -> SharepointServiceFactory.getInstance().getClient(config, connection).recycleFile(fileServerRelativeUrl));
    }

    @Query(translator=SharepointQueryTranslator.DummyQueryTranslator.class, entityResolver=FileMetadataResolver.class, nativeOutputResolver=NativeFileQueryMetadataResolver.class)
    public List<Map<String, Object>> fileQuery(@Config SharepointConfiguration config, @Connection SharepointConnection connection, @Text @MetadataKeyId String query, @Optional(defaultValue="/") String startingFolderPath, @Optional(defaultValue="false") boolean recursive) {
        if (logger.isDebugEnabled()) {
            logger.debug("Calling file query with query: {} starting folder path: {} and recursive: {}", new Object[]{query, startingFolderPath, recursive});
        }
        SharepointService service = SharepointServiceFactory.getInstance().getClient(config, connection);
        query = SharepointUtils.translateDsqlQuery(service, query);
        query = SharepointQueryTranslator.keepOnlyOriginalIfMapped(query);
        String expandedQuery = ODataHelper.expandIfNecessary(query, Lists.newArrayList((Object[])new String[]{"Author", "CheckedOutByUser", "LockedByUser", "ModifiedBy", "Versions", "ListItemAllFields"}));
        String parsedFolderPath = ConnectorUtils.removeEnd(SharepointUtils.extractPath(expandedQuery) + startingFolderPath, "/");
        return connection.execute(() -> SharepointServiceFactory.getInstance().getClient(config, connection).queryFile(SharepointUtils.extractQueryString(expandedQuery), parsedFolderPath, recursive));
    }

    @Throws(value={SharepointErrorTypeProvider.class})
    @OutputResolver(output=ObjectMetadataResolver.class)
    public Map<String, Object> resolveObject(@Config SharepointConfiguration config, @Connection SharepointConnection connection, String url, @Optional(defaultValue="Get") @DisplayName(value="Request Type") ResolveRequestType resolveRequestType, @Content @Optional @DisplayName(value="Request Body") Object body) {
        if (logger.isDebugEnabled()) {
            logger.debug("Calling resolve object with url: {}", (Object)url);
        }
        return connection.execute(() -> SharepointServiceFactory.getInstance().getClient(config, connection).resolveObject(url, resolveRequestType, body));
    }

    @Throws(value={SharepointErrorTypeProvider.class})
    @OutputResolver(output=CollectionMetadataResolver.class)
    public List<Map<String, Object>> resolveCollection(@Config SharepointConfiguration config, @Connection SharepointConnection connection, String url) {
        if (logger.isDebugEnabled()) {
            logger.debug("Calling resolve collection with url: {}", (Object)url);
        }
        return connection.execute(() -> SharepointServiceFactory.getInstance().getClient(config, connection).resolveCollection(url));
    }

    public void fileMove(@Config SharepointConfiguration config, @Connection SharepointConnection connection, String fileServerRelativeUrl, String newFileServerRelativeUrl, @Optional(defaultValue="1") int flag) {
        if (logger.isDebugEnabled()) {
            logger.debug("Calling file copy to with file server relative url: {} new file server relative url: {} and flag: {}", new Object[]{fileServerRelativeUrl, newFileServerRelativeUrl, flag});
        }
        connection.execute(() -> {
            SharepointServiceFactory.getInstance().getClient(config, connection).moveFileTo(fileServerRelativeUrl, newFileServerRelativeUrl, flag);
            return null;
        });
    }
}

