/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.sharepoint.internal.metadata.specialist.operations.manager;

import com.mulesoft.connectors.sharepoint.internal.metadata.specialist.operations.manager.MetadataIteratorResolver;
import com.mulesoft.connectors.sharepoint.internal.metadata.specialist.operations.manager.MetadataResolutionContext;
import com.mulesoft.connectors.sharepoint.internal.metadata.specialist.operations.manager.MetadataResolutionProvider;
import com.mulesoft.connectors.sharepoint.internal.service.SharepointService;
import com.mulesoft.connectors.sharepoint.internal.service.mapping.entity.SharepointListField;
import com.mulesoft.connectors.sharepoint.internal.service.utils.caching.ICacheWRP;
import com.mulesoft.connectors.sharepoint.internal.service.utils.caching.impl.LRUCacheWRP;
import com.mulesoft.connectors.sharepoint.internal.utils.ConnectorUtils;
import java.util.List;

public class MetadataManager {
    private static final String ID = "Id";
    private final ICacheWRP<String, MetadataResolutionContext, List<SharepointListField>> metaDataCache;

    public MetadataManager(SharepointService sharepointClient) {
        this.metaDataCache = new LRUCacheWRP<String, MetadataResolutionContext, List<SharepointListField>>(15, new MetadataResolutionProvider(sharepointClient));
    }

    public String getReferenceListId(String listId, String fieldName) {
        return this.iterateAndResolve(listId, this.removeIdFromFieldName(fieldName), null, (fieldName1, fieldMetadata) -> this.normalizeListId(fieldMetadata.getLookupList()));
    }

    public boolean hasLookupList(String listId, String fieldName) {
        return this.iterateAndResolve(listId, this.removeIdFromFieldName(fieldName), false, (fieldName1, fieldMetadata) -> fieldMetadata.hasLookupList());
    }

    public boolean isLookupField(String listId, String fieldName) {
        return this.iterateAndResolve(listId, this.removeIdFromFieldName(fieldName), false, (fieldName1, fieldMetadata) -> fieldMetadata.isLookupField());
    }

    public boolean isMultiValueField(String listId, String fieldName) {
        return this.iterateAndResolve(listId, this.removeIdFromFieldName(fieldName), false, (fieldName1, fieldMetadata) -> fieldMetadata.isMultiValueField());
    }

    public boolean isMultiChoiceField(String listId, String fieldName) {
        return this.iterateAndResolve(listId, this.removeIdFromFieldName(fieldName), false, (fieldName1, fieldMetadata) -> fieldMetadata.isMultiChoiceField());
    }

    public boolean isTaxonomyField(String listId, String fieldName) {
        return this.iterateAndResolve(listId, this.removeIdFromFieldName(fieldName), false, (fieldName1, fieldMetadata) -> fieldMetadata.isTaxonomyField());
    }

    public String mapToInternalName(String listId, String fieldName, boolean removeId) {
        String result = this.iterateAndResolve(listId, fieldName, fieldName, (fieldName1, fieldMetadata) -> fieldMetadata.isLookupField() ? fieldMetadata.getInternalName() + ID : fieldMetadata.getInternalName());
        if (removeId && this.isLookupField(listId, result)) {
            result = this.removeIdFromFieldName(result);
        }
        return result;
    }

    public String removeIdFromFieldName(String fieldName) {
        if (fieldName == null || fieldName.length() < 3) {
            return fieldName;
        }
        return ConnectorUtils.removeEnd(fieldName, ID);
    }

    public List<SharepointListField> getFields(String listId) {
        return this.metaDataCache.resolve(new MetadataResolutionContext(listId));
    }

    private String normalizeListId(String listId) {
        return ConnectorUtils.removeEnd(ConnectorUtils.removeStart(listId, "{"), "}");
    }

    private <T> T iterateAndResolve(String listId, String fieldName, T initValue, MetadataIteratorResolver<T> resolver) {
        T result = initValue;
        for (SharepointListField field : this.metaDataCache.resolve(new MetadataResolutionContext(listId))) {
            if (fieldName.equalsIgnoreCase(field.getInternalName())) {
                result = resolver.resolve(fieldName, field);
                break;
            }
            if (!fieldName.equalsIgnoreCase(field.getTitle())) continue;
            result = resolver.resolve(fieldName, field);
        }
        return result;
    }
}

