/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.sharepoint.internal.connection.provider;

import com.mulesoft.connectors.sharepoint.internal.connection.OAuthAuthorizationCodeConnection;
import com.mulesoft.connectors.sharepoint.internal.connection.SharepointConnection;
import com.mulesoft.connectors.sharepoint.internal.connection.provider.AbstractSharepointConnectionProvider;
import com.mulesoft.connectors.sharepoint.internal.service.proxy.HttpClientContextPair;
import com.mulesoft.connectors.sharepoint.internal.service.utils.AuthUtils;
import com.mulesoft.connectors.sharepoint.internal.utils.HttpClientFactory;
import java.net.URL;
import java.text.MessageFormat;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.connectivity.oauth.AuthorizationCode;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.connectivity.oauth.AuthorizationCodeState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AuthorizationCode(authorizationUrl="https://login.microsoftonline.com/{tenant}/oauth2/v2.0/authorize", accessTokenUrl="https://login.microsoftonline.com/{tenant}/oauth2/v2.0/token")
@Alias(value="oauth-authorization-code")
@DisplayName(value="OAuth v2.0 Authorization Code")
public class OAuthAuthorizationCodeGrantConnectionProvider
extends AbstractSharepointConnectionProvider {
    private static final Logger logger = LoggerFactory.getLogger(OAuthAuthorizationCodeGrantConnectionProvider.class);
    private AuthorizationCodeState state;
    private HttpClientFactory httpClientFactory;

    @Override
    public void initialise() {
        this.httpClientFactory = new HttpClientFactory();
    }

    public SharepointConnection connect() throws ConnectionException {
        try {
            if (this.state.getAccessToken() == null) {
                throw new ConnectionException(MessageFormat.format("Could not extract field {0}", "accessToken"));
            }
            this.httpClient = this.httpClientFactory.createHttpClientBuilder(this.disableCnCheck, this.proxySettings).build();
            URL serviceURL = AuthUtils.buildUrl(this.getSiteUrl());
            logger.info("Connection established!");
            return new OAuthAuthorizationCodeConnection(serviceURL, new HttpClientContextPair(this.httpClient, (HttpContext)new BasicHttpContext()), this.state);
        }
        catch (ConnectionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConnectionException(e.getMessage(), (Throwable)e);
        }
    }
}

