/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.sharepoint.internal.connection.provider;

import com.mulesoft.connectors.sharepoint.api.ProxySettings;
import com.mulesoft.connectors.sharepoint.internal.connection.SharepointConnection;
import com.mulesoft.connectors.sharepoint.internal.connection.provider.AbstractSharepointConnectionProvider;
import com.mulesoft.connectors.sharepoint.internal.service.proxy.HttpClientContextPair;
import com.mulesoft.connectors.sharepoint.internal.service.security.DefaultLoginConfiguration;
import com.mulesoft.connectors.sharepoint.internal.service.security.KerberosLogin;
import com.mulesoft.connectors.sharepoint.internal.service.security.LoginService;
import com.mulesoft.connectors.sharepoint.internal.service.utils.AuthUtils;
import com.mulesoft.connectors.sharepoint.internal.utils.ConnectorUtils;
import com.mulesoft.connectors.sharepoint.internal.utils.HttpClientFactory;
import com.mulesoft.connectors.sharepoint.internal.utils.SharepointUtils;
import java.io.FileNotFoundException;
import java.net.URL;
import javax.security.auth.login.Configuration;
import org.apache.http.protocol.HttpContext;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.sdk.api.annotation.semantics.SemanticTerms;
import org.mule.sdk.api.annotation.semantics.connectivity.ExcludeFromConnectivitySchema;
import org.mule.sdk.api.annotation.semantics.connectivity.KerberosAuth;
import org.mule.sdk.api.annotation.semantics.security.Password;
import org.mule.sdk.api.annotation.semantics.security.Username;

@KerberosAuth
@Alias(value="kerberos")
public class KerberosConnectionProvider
extends AbstractSharepointConnectionProvider {
    private static final String UNABLE_TO_DETECT_KRB_CONFIG = "Unable to automatically detect Kerberos configuration settings. Enter both the 'Realm' and the 'KDC'.";
    private static final String REALM_AND_KDC_MUST_BE_BLANK = "When specifying the 'Kerberos properties file path', 'Realm' and 'KDC' must be left blank.";
    private static final String KRB_FILE_IS_BLANK_AND_REALM_OR_KRBB_ARE_BLANK = "Both the 'Realm' and the 'KDC' have to be entered. For advanced scenarios, kerberos can be configured specifying the 'Kerberos properties file path' created as described at http://web.mit.edu/kerberos/krb5-devel/doc/admin/conf_files/krb5_conf.html.";
    @Username
    @Parameter
    private String kerberosUsername;
    @Password
    @Parameter
    private String kerberosPassword;
    @SemanticTerms(value={"SPN"})
    @DisplayName(value="SPN")
    @Parameter
    @Optional
    @Summary(value="(Optional) SPN for the SharePoint Web Service.")
    private String spn;
    @SemanticTerms(value={"Realm"})
    @DisplayName(value="Realm")
    @Parameter
    @Optional
    @Summary(value="(Optional) The case-sensitive default realm (Domain Name) that the user belongs to.")
    private String realm;
    @SemanticTerms(value={"KDC"})
    @DisplayName(value="KDC")
    @Parameter
    @Optional
    @Summary(value="(Optional) The KDC (usually the Domain Controller name) to authenticate the user.")
    private String kdc;
    @ExcludeFromConnectivitySchema
    @DisplayName(value="Login Properties File Path")
    @Parameter
    @Optional
    @Summary(value="(Optional) Path to a customized Login Properties File. When not specified, default values which usually work for most cases will be set up.")
    private String loginPropertiesFilePath;
    @ExcludeFromConnectivitySchema
    @DisplayName(value="Kerberos Properties File Path")
    @Parameter
    @Optional
    @Summary(value="(Optional) Path to a customized Kerberos Properties File.")
    private String kerberosPropertiesFilePath;

    @Override
    public void initialise() {
        HttpClientFactory httpClientFactory = new HttpClientFactory();
        this.httpClient = httpClientFactory.createForKerberos(this.spn, this.disableCnCheck, this.proxySettings);
    }

    public SharepointConnection connect() throws ConnectionException {
        this.clearSystemProperties();
        this.setKerberosSystemProperties();
        this.checkCredentialsParameters();
        try {
            LoginService loginService = new LoginService(this.httpClient);
            URL serviceURL = AuthUtils.buildUrl(this.getSiteUrl());
            KerberosLogin kerberosLogin = this.buildKerberosLogin();
            HttpContext httpContext = loginService.login(kerberosLogin);
            return new SharepointConnection(serviceURL, new HttpClientContextPair(this.httpClient, httpContext));
        }
        catch (ConnectionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConnectionException(e.getMessage(), (Throwable)e);
        }
    }

    private KerberosLogin buildKerberosLogin() {
        KerberosLogin kerberosLogin = new KerberosLogin();
        kerberosLogin.setUsername(this.kerberosUsername);
        kerberosLogin.setPassword(this.kerberosPassword);
        return kerberosLogin;
    }

    private void setKerberosSystemProperties() throws ConnectionException {
        if (!ConnectorUtils.isStringNullOrEmpty(this.loginPropertiesFilePath)) {
            this.setConfigFileSystemProperty(this.loginPropertiesFilePath, "java.security.auth.login.config", "The loginPropertiesFile can not be found");
        } else {
            Configuration.setConfiguration(new DefaultLoginConfiguration(Boolean.TRUE));
        }
        if (!ConnectorUtils.isStringNullOrEmpty(this.kerberosPropertiesFilePath)) {
            this.setConfigFileSystemProperty(this.kerberosPropertiesFilePath, "java.security.krb5.conf", "The kerberosPropertiesFile can not be found");
        } else {
            System.setProperty("java.security.krb5.realm", this.realm);
            System.setProperty("java.security.krb5.kdc", this.kdc);
            System.setProperty("javax.security.auth.useSubjectCredsOnly", Boolean.FALSE.toString());
        }
    }

    private void setConfigFileSystemProperty(String configFilePath, String systemProperty, String errorMessage) throws ConnectionException {
        try {
            String replacedConfigFilePath = SharepointUtils.resolvePathToAbsolutePath(configFilePath);
            System.setProperty(systemProperty, replacedConfigFilePath);
        }
        catch (FileNotFoundException e) {
            throw new ConnectionException(errorMessage + " " + configFilePath, (Throwable)e);
        }
    }

    private void checkCredentialsParameters() throws ConnectionException {
        if (this.realmKdcAndKrbFileAreBlank()) {
            throw new ConnectionException(UNABLE_TO_DETECT_KRB_CONFIG);
        }
        if (this.krbFileIsNotBlankAndRealmOrKdcAreNotBlank()) {
            throw new ConnectionException(REALM_AND_KDC_MUST_BE_BLANK);
        }
        if (this.krbFileIsBlankAndRealmOrKdcAreBlank()) {
            throw new ConnectionException(KRB_FILE_IS_BLANK_AND_REALM_OR_KRBB_ARE_BLANK);
        }
    }

    private boolean realmKdcAndKrbFileAreBlank() {
        return (ConnectorUtils.isBlank(this.realm) || ConnectorUtils.isBlank(this.kdc)) && ConnectorUtils.isBlank(this.kerberosPropertiesFilePath);
    }

    private boolean krbFileIsNotBlankAndRealmOrKdcAreNotBlank() {
        return ConnectorUtils.isNotBlank(this.kerberosPropertiesFilePath) && (ConnectorUtils.isNotBlank(this.realm) || ConnectorUtils.isNotBlank(this.kdc));
    }

    private boolean krbFileIsBlankAndRealmOrKdcAreBlank() {
        return ConnectorUtils.isBlank(this.kerberosPropertiesFilePath) && (ConnectorUtils.isBlank(this.realm) || ConnectorUtils.isBlank(this.kdc));
    }

    private void clearSystemProperties() {
        System.clearProperty("java.security.auth.login.config");
        System.clearProperty("java.security.krb5.realm");
        System.clearProperty("java.security.krb5.kdc");
        System.clearProperty("java.security.krb5.conf");
    }

    public String getKerberosUsername() {
        return this.kerberosUsername;
    }

    public void setKerberosUsername(String kerberosUsername) {
        this.kerberosUsername = kerberosUsername;
    }

    public String getKerberosPassword() {
        return this.kerberosPassword;
    }

    public void setKerberosPassword(String kerberosPassword) {
        this.kerberosPassword = kerberosPassword;
    }

    public String getSpn() {
        return this.spn;
    }

    public void setSpn(String spn) {
        this.spn = spn;
    }

    public String getRealm() {
        return this.realm;
    }

    public void setRealm(String realm) {
        this.realm = realm;
    }

    public String getKdc() {
        return this.kdc;
    }

    public void setKdc(String kdc) {
        this.kdc = kdc;
    }

    public String getLoginPropertiesFilePath() {
        return this.loginPropertiesFilePath;
    }

    public void setLoginPropertiesFilePath(String loginPropertiesFilePath) {
        this.loginPropertiesFilePath = loginPropertiesFilePath;
    }

    public String getKerberosPropertiesFilePath() {
        return this.kerberosPropertiesFilePath;
    }

    public void setKerberosPropertiesFilePath(String kerberosPropertiesFilePath) {
        this.kerberosPropertiesFilePath = kerberosPropertiesFilePath;
    }

    public boolean isDisableCnCheck() {
        return this.disableCnCheck;
    }

    public void setDisableCnCheck(boolean disableCnCheck) {
        this.disableCnCheck = disableCnCheck;
    }

    public ProxySettings getProxySettings() {
        return this.proxySettings;
    }

    public void setProxySettings(ProxySettings proxySettings) {
        this.proxySettings = proxySettings;
    }
}

