/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.sharepoint.internal.connection.provider;

import com.mulesoft.connectors.sharepoint.api.ProxySettings;
import com.mulesoft.connectors.sharepoint.internal.connection.SharepointConnection;
import com.mulesoft.connectors.sharepoint.internal.connection.provider.AbstractSharepointConnectionProvider;
import com.mulesoft.connectors.sharepoint.internal.service.proxy.HttpClientContextPair;
import com.mulesoft.connectors.sharepoint.internal.service.security.ClaimsLogin;
import com.mulesoft.connectors.sharepoint.internal.service.security.LoginService;
import com.mulesoft.connectors.sharepoint.internal.service.utils.AuthUtils;
import com.mulesoft.connectors.sharepoint.internal.utils.ConnectorUtils;
import org.apache.http.protocol.HttpContext;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.sdk.api.annotation.semantics.SemanticTerms;
import org.mule.sdk.api.annotation.semantics.connectivity.Url;
import org.mule.sdk.api.annotation.semantics.security.Password;
import org.mule.sdk.api.annotation.semantics.security.Username;

@Alias(value="claims")
public class ClaimsConnectionProvider
extends AbstractSharepointConnectionProvider {
    private static final String USERNAME_OR_PASSWORD_IS_NULL_MESSAGE = "Claims Username and Claims Password can not be null.";
    @Username
    @Parameter
    private String claimsUsername;
    @Password
    @Parameter
    private String claimsPassword;
    @Url
    @Parameter
    private String stsUrl;
    @SemanticTerms(value={"Scope"})
    @Parameter
    private String scope;

    public SharepointConnection connect() throws ConnectionException {
        this.checkCredentialsParameters(this.claimsUsername, this.claimsPassword);
        try {
            LoginService loginService = new LoginService(this.httpClient);
            ClaimsLogin claimsLogin = this.buildClaimsLoginRequest();
            HttpContext httpContext = loginService.login(claimsLogin);
            return new SharepointConnection(claimsLogin.getServiceUrl(), new HttpClientContextPair(this.httpClient, httpContext));
        }
        catch (ConnectionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConnectionException(e.getMessage(), (Throwable)e);
        }
    }

    private void checkCredentialsParameters(String username, String password) {
        if (ConnectorUtils.isStringNullOrEmpty(username) || ConnectorUtils.isStringNullOrEmpty(password)) {
            throw new IllegalArgumentException(USERNAME_OR_PASSWORD_IS_NULL_MESSAGE);
        }
    }

    private ClaimsLogin buildClaimsLoginRequest() throws ConnectionException {
        ClaimsLogin claimsLogin = new ClaimsLogin();
        claimsLogin.setUsername(this.claimsUsername);
        claimsLogin.setPassword(this.claimsPassword);
        claimsLogin.setServiceUrl(AuthUtils.buildUrl(this.getSiteUrl()));
        claimsLogin.setStsUrl(this.stsUrl);
        claimsLogin.setScope(this.scope);
        return claimsLogin;
    }

    public String getClaimsUsername() {
        return this.claimsUsername;
    }

    public void setClaimsUsername(String claimsUsername) {
        this.claimsUsername = claimsUsername;
    }

    public String getClaimsPassword() {
        return this.claimsPassword;
    }

    public void setClaimsPassword(String claimsPassword) {
        this.claimsPassword = claimsPassword;
    }

    public String getStsUrl() {
        return this.stsUrl;
    }

    public void setStsUrl(String stsUrl) {
        this.stsUrl = stsUrl;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public boolean isDisableCnCheck() {
        return this.disableCnCheck;
    }

    public void setDisableCnCheck(boolean disableCnCheck) {
        this.disableCnCheck = disableCnCheck;
    }

    public ProxySettings getProxySettings() {
        return this.proxySettings;
    }

    public void setProxySettings(ProxySettings proxySettings) {
        this.proxySettings = proxySettings;
    }
}

