/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.sharepoint.internal.connection;

import com.mulesoft.connectors.sharepoint.internal.connection.OAuthAuthorizationCodeConnection;
import com.mulesoft.connectors.sharepoint.internal.connection.executable.MicrosoftSharepointExecutable;
import com.mulesoft.connectors.sharepoint.internal.error.SharepointErrorType;
import com.mulesoft.connectors.sharepoint.internal.error.exception.InternalServerException;
import com.mulesoft.connectors.sharepoint.internal.error.exception.SharepointException;
import com.mulesoft.connectors.sharepoint.internal.error.exception.UnableToSendException;
import com.mulesoft.connectors.sharepoint.internal.service.proxy.HttpClientContextPair;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;
import org.apache.http.client.HttpResponseException;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.extension.api.connectivity.oauth.AccessTokenExpiredException;
import org.mule.runtime.extension.api.connectivity.oauth.AuthorizationCodeState;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;

public class SharepointConnection {
    protected URL serviceURL;
    protected HttpClientContextPair httpClientContextPair;

    public SharepointConnection(URL serviceURL, HttpClientContextPair httpClientContextPair) {
        this.serviceURL = serviceURL;
        this.httpClientContextPair = httpClientContextPair;
    }

    public void disconnect() {
        if (this.httpClientContextPair != null && this.httpClientContextPair.getClient() != null) {
            this.httpClientContextPair = null;
        }
    }

    public void validate() {
        if (this.httpClientContextPair == null) {
            throw new SharepointException("Invalid connection", new ConnectionException("Invalid connection"));
        }
    }

    public URL getServiceURL() {
        return this.serviceURL;
    }

    public HttpClientContextPair getHttpClientContextPair() {
        return this.httpClientContextPair;
    }

    public <T> T execute(MicrosoftSharepointExecutable<T> executable) {
        try {
            return executable.execute();
        }
        catch (SharepointException exception) {
            if (this.isConnectivityException(exception)) {
                throw new ModuleException(exception.getMessage(), (ErrorTypeDefinition)SharepointErrorType.CONNECTIVITY, (Throwable)exception);
            }
            throw new ModuleException(exception.getMessage(), (ErrorTypeDefinition)SharepointErrorType.UNKNOWN, (Throwable)exception);
        }
        catch (UnableToSendException exception) {
            throw this.handleUnableToSendException(exception);
        }
        catch (InternalServerException exception) {
            throw new ModuleException(exception.getMessage(), (ErrorTypeDefinition)SharepointErrorType.CONNECTIVITY, (Throwable)new ConnectionException((Throwable)exception));
        }
        catch (ModuleException exception) {
            if (exception.getType() == SharepointErrorType.INVALID_PARAMETERS) {
                throw exception;
            }
            throw new ModuleException(exception.getMessage(), (ErrorTypeDefinition)SharepointErrorType.UNKNOWN, (Throwable)exception);
        }
        catch (Exception exception) {
            throw new ModuleException(exception.getMessage(), (ErrorTypeDefinition)SharepointErrorType.UNKNOWN, (Throwable)exception);
        }
    }

    private boolean isConnectivityException(SharepointException exception) {
        if (exception.getCause() instanceof SocketException && exception.getMessage().contains("Software caused connection abort")) {
            return Boolean.TRUE;
        }
        if (exception.getCause() instanceof UnknownHostException) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private MuleRuntimeException handleUnableToSendException(UnableToSendException exception) {
        if (exception.getCause() instanceof HttpResponseException) {
            HttpResponseException httpResponseException = (HttpResponseException)exception.getCause();
            int originalExceptionStatusCode = httpResponseException.getStatusCode();
            switch (originalExceptionStatusCode) {
                case 401: {
                    AuthorizationCodeState state;
                    if (!(this instanceof OAuthAuthorizationCodeConnection) || !(state = ((OAuthAuthorizationCodeConnection)this).getAuthorizationCodeState()).getRefreshToken().isPresent()) break;
                    return new AccessTokenExpiredException(state.getResourceOwnerId());
                }
                case 404: {
                    return new ModuleException(exception.getMessage(), (ErrorTypeDefinition)SharepointErrorType.NOT_FOUND, (Throwable)exception);
                }
            }
        }
        return new ModuleException(exception.getMessage(), (ErrorTypeDefinition)SharepointErrorType.CONNECTIVITY, (Throwable)new ConnectionException((Throwable)exception));
    }
}

