/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.salesforce.analytics.internal.util;

public class StringUtil {
    private static final String START_REGEX_QUOTE = "^[\"']+";
    private static final String END_REGEX_QUOTE = "[\"']+$";
    private static final String EMPTY_STRING = "";

    private StringUtil() {
    }

    public static String unquote(String value) {
        String endStripped = null;
        if (value != null) {
            String startStripped = value.replaceAll(START_REGEX_QUOTE, EMPTY_STRING);
            endStripped = startStripped.replaceAll(END_REGEX_QUOTE, EMPTY_STRING);
        }
        return endStripped;
    }

    public static String quote(String value) {
        if (value == null) {
            return StringUtil.quote(EMPTY_STRING);
        }
        return String.format("\"%s\"", value);
    }
}

