/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.salesforce.analytics.internal.util;

import com.google.gson.Gson;
import com.sforce.soap.partner.sobject.SObject;
import com.sforce.ws.ConnectionException;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.ObjectTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.java.api.JavaTypeLoader;
import org.mule.modules.salesforce.analytics.internal.connection.SalesforceAnalyticsConnection;
import org.mule.modules.salesforce.analytics.internal.error.exception.InvalidDataSetIDException;
import org.mule.modules.salesforce.analytics.internal.error.exception.MetadataException;
import org.mule.modules.salesforce.analytics.internal.metadata.AnalyticsMetadataInfo;
import org.mule.modules.salesforce.analytics.internal.metadata.ContentMetadata;
import org.mule.modules.salesforce.analytics.internal.metadata.FieldMetadata;
import org.mule.runtime.core.api.util.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataUtil {
    private static final Logger logger = LoggerFactory.getLogger(MetadataUtil.class);
    private static final String METADATA_JSON = "MetadataJson";
    private static final String INSIGHTS_EXTERNAL_DATA = "InsightsExternalData";

    private MetadataUtil() {
    }

    public static AnalyticsMetadataInfo getAnalyticsMetadata(SalesforceAnalyticsConnection connection, String entityKey) throws IOException, ConnectionException {
        SObject[] insightsExternalData = connection.getPartnerConnection().retrieve(METADATA_JSON, INSIGHTS_EXTERNAL_DATA, new String[]{entityKey});
        if (insightsExternalData == null || insightsExternalData[0] == null) {
            throw new InvalidDataSetIDException("Data Set ID " + entityKey + " was not found");
        }
        SObject insightsExternalDataObject = insightsExternalData[0];
        String encodedJson = (String)insightsExternalDataObject.getSObjectField(METADATA_JSON);
        Gson mapper = new Gson();
        return (AnalyticsMetadataInfo)mapper.fromJson(new String(Base64.getDecoder().decode(encodedJson)), AnalyticsMetadataInfo.class);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static AnalyticsMetadataInfo loadMetadataFromFile(String filePath) throws MetadataException {
        Gson mapper = new Gson();
        Path path = Paths.get(filePath, new String[0]);
        if (path.isAbsolute()) {
            try (FileInputStream inputStream = new FileInputStream(filePath);){
                AnalyticsMetadataInfo analyticsMetadataInfo = (AnalyticsMetadataInfo)mapper.fromJson(IOUtils.toString((InputStream)inputStream), AnalyticsMetadataInfo.class);
                return analyticsMetadataInfo;
            }
            catch (IOException e) {
                throw new MetadataException("Failed reading metadata file:" + e.getMessage(), e);
            }
        }
        try (InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(filePath);){
            AnalyticsMetadataInfo analyticsMetadataInfo = (AnalyticsMetadataInfo)mapper.fromJson(IOUtils.toString((InputStream)inputStream), AnalyticsMetadataInfo.class);
            return analyticsMetadataInfo;
        }
        catch (IOException e) {
            throw new MetadataException("Failed reading metadata file:" + e.getMessage(), e);
        }
    }

    public static void addSimpleField(ObjectTypeBuilder objectTypeBuilder, FieldMetadata fieldMetadata) {
        switch (fieldMetadata.getType()) {
            case NUMERIC: {
                objectTypeBuilder.addField().key(fieldMetadata.getName()).label(fieldMetadata.getName()).value().numberType();
                break;
            }
            case DATE: {
                objectTypeBuilder.addField().key(fieldMetadata.getName()).label(fieldMetadata.getName()).value().dateTimeType();
                break;
            }
            case TEXT: {
                MetadataUtil.addTextField(objectTypeBuilder, fieldMetadata);
                break;
            }
            default: {
                logger.warn("Unknown field type: {}", (Object)fieldMetadata.getType());
            }
        }
    }

    private static void addTextField(ObjectTypeBuilder objectTypeBuilder, FieldMetadata fieldMetadata) {
        if (fieldMetadata.getIsMultiValue() != null && fieldMetadata.getIsMultiValue().booleanValue()) {
            BaseTypeBuilder typeBuilder = new BaseTypeBuilder(JavaTypeLoader.JAVA);
            objectTypeBuilder.addField().key(fieldMetadata.getName()).label(fieldMetadata.getName()).value().arrayType().of((TypeBuilder)typeBuilder.stringType().id(fieldMetadata.getName()));
        } else {
            objectTypeBuilder.addField().key(fieldMetadata.getName()).label(fieldMetadata.getName()).value().stringType();
        }
    }

    public static Map<String, FieldMetadata> mapMetadata(ContentMetadata contentMetadata) throws MetadataException {
        MetadataUtil.validateContentMetadata(contentMetadata);
        HashMap<String, FieldMetadata> mappings = new HashMap<String, FieldMetadata>();
        for (FieldMetadata fieldMetadata : contentMetadata.getFields()) {
            mappings.put(fieldMetadata.getName(), fieldMetadata);
        }
        return mappings;
    }

    private static void validateContentMetadata(ContentMetadata contentMetadata) throws MetadataException {
        if (contentMetadata == null) {
            throw new MetadataException("Content metadata can not be null");
        }
        MetadataUtil.validateMetadataFields(contentMetadata.getFields());
    }

    private static void validateMetadataFields(List<FieldMetadata> metadataFields) throws MetadataException {
        if (metadataFields == null) {
            throw new MetadataException("Collection of fields metadata can not be null.");
        }
    }
}

