/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.salesforce.analytics.internal.service.transaction;

import com.sforce.soap.partner.DeleteResult;
import com.sforce.soap.partner.PartnerConnection;
import com.sforce.soap.partner.SaveResult;
import com.sforce.soap.partner.fault.ApiQueryFault;
import com.sforce.soap.partner.fault.ExceptionCode;
import com.sforce.soap.partner.fault.UnexpectedErrorFault;
import com.sforce.soap.partner.sobject.SObject;
import com.sforce.ws.ConnectionException;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.mule.modules.salesforce.analytics.internal.error.AnalyticsErrorType;
import org.mule.modules.salesforce.analytics.internal.error.exception.AnalyticsException;
import org.mule.modules.salesforce.analytics.internal.metadata.Action;
import org.mule.modules.salesforce.analytics.internal.service.transaction.ParentDTO;
import org.mule.modules.salesforce.analytics.internal.util.Constants;
import org.mule.modules.salesforce.analytics.internal.util.SObjectBuilder;
import org.mule.runtime.api.store.ObjectStore;
import org.mule.runtime.api.store.ObjectStoreException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnalyticsUploader {
    private static final Logger logger = LoggerFactory.getLogger(AnalyticsUploader.class);

    public String createParent(PartnerConnection partnerConnection, ParentDTO parentDTO) {
        logger.debug("Metadata content: \n {}", (Object)parentDTO.getMetadataJson());
        SObject sObject = this.prepareParentObject(parentDTO, Action.NONE.getName());
        SaveResult[] results = this.createObject(partnerConnection, sObject);
        SaveResult saveResult = results[0];
        if (!saveResult.isSuccess()) {
            throw new AnalyticsException(saveResult.toString(), AnalyticsErrorType.TRANSACTION);
        }
        String parentID = saveResult.getId();
        return parentID;
    }

    private SObject prepareParentObject(ParentDTO parentDTO, String action) {
        SObjectBuilder sObjectBuilder = SObjectBuilder.create("InsightsExternalData");
        this.setFieldsOnSObjectBuilder(parentDTO, action, sObjectBuilder);
        return sObjectBuilder.build();
    }

    private void setFieldsOnSObjectBuilder(ParentDTO parentDTO, String action, SObjectBuilder sObjectBuilder) {
        sObjectBuilder.setId(null);
        this.setFieldOnSObjectBuilderIfNotNullOrEmpty("Format", parentDTO.getFormat(), sObjectBuilder);
        this.setFieldOnSObjectBuilderIfNotNullOrEmpty("EdgemartAlias", parentDTO.getEdgemartAlias(), sObjectBuilder);
        this.setFieldOnSObjectBuilderIfNotNullOrEmpty("Operation", parentDTO.getOperation(), sObjectBuilder);
        this.setFieldOnSObjectBuilderIfNotNullOrEmpty("Action", action, sObjectBuilder);
        this.setFieldOnSObjectBuilderIfNotNullOrEmpty("EdgemartContainer", parentDTO.getEdgemartContainer(), sObjectBuilder);
        this.setFieldOnSObjectBuilderIfNotNullOrEmpty("NotificationSent", parentDTO.getNotificationSent(), sObjectBuilder);
        this.setFieldOnSObjectBuilderIfNotNullOrEmpty("NotificationEmail", parentDTO.getNotificationEmail(), sObjectBuilder);
        this.setMetadataOnSObjectBuilder(parentDTO.getMetadataJson(), sObjectBuilder);
    }

    private void setMetadataOnSObjectBuilder(String metadataJson, SObjectBuilder sObjectBuilder) throws AnalyticsException {
        if (StringUtils.isNotEmpty((CharSequence)metadataJson)) {
            try {
                sObjectBuilder.setField("MetadataJson", metadataJson.getBytes(Constants.Encodings.UTF8));
            }
            catch (UnsupportedEncodingException e) {
                throw new AnalyticsException(e.getMessage(), AnalyticsErrorType.UNKNOWN);
            }
        }
    }

    private void setFieldOnSObjectBuilderIfNotNullOrEmpty(String fieldName, String fieldValue, SObjectBuilder sObjectBuilder) {
        if (StringUtils.isNotEmpty((CharSequence)fieldValue)) {
            sObjectBuilder.setField(fieldName, fieldValue);
        }
    }

    private SaveResult[] createObject(PartnerConnection partnerConnection, SObject sObject) {
        SaveResult[] results = null;
        try {
            results = partnerConnection.create(new SObject[]{sObject});
        }
        catch (ConnectionException e) {
            AnalyticsUploader.logSOAPErrorAndRethrow("Failed creating object into salesforce", (Exception)((Object)e));
        }
        if (ArrayUtils.isEmpty(results)) {
            throw new AnalyticsException("Failed sending header info", AnalyticsErrorType.UNKNOWN);
        }
        return results;
    }

    private SaveResult[] updateObject(PartnerConnection partnerConnection, SObject sObject) {
        SaveResult[] results = null;
        try {
            results = partnerConnection.update(new SObject[]{sObject});
        }
        catch (ConnectionException e) {
            AnalyticsUploader.logSOAPErrorAndRethrow("Failed triggering process of edgemart", (Exception)((Object)e));
        }
        if (ArrayUtils.isEmpty(results)) {
            throw new AnalyticsException("Failed triggering process of edgemart", AnalyticsErrorType.UNKNOWN);
        }
        return results;
    }

    private DeleteResult[] deleteObject(PartnerConnection partnerConnection, String sObjectId) {
        DeleteResult[] results = null;
        try {
            results = partnerConnection.delete(new String[]{sObjectId});
        }
        catch (ConnectionException e) {
            AnalyticsUploader.logSOAPErrorAndRethrow("Failed deleting the dataset", (Exception)((Object)e));
        }
        if (ArrayUtils.isEmpty(results)) {
            throw new AnalyticsException("Failed deleting the dataset", AnalyticsErrorType.UNKNOWN);
        }
        return results;
    }

    public void sendDataPart(PartnerConnection partnerConnection, String parentId, byte[] content, int partNo, ObjectStore<Integer> simpleMemoryObjectStore) throws IOException {
        SaveResult[] results;
        logger.info("Sending data part to Analytics cloud - started: {}", (Object)partNo);
        SObject sObject = SObjectBuilder.create("InsightsExternalDataPart").setField("DataFile", content).setField("InsightsExternalDataId", parentId).setField("PartNumber", partNo).build();
        for (SaveResult sv : results = this.createObject(partnerConnection, sObject)) {
            if (sv.isSuccess()) {
                logger.info("Part number: {} saved with id: {}", (Object)partNo, (Object)sv.getId());
                try {
                    if (simpleMemoryObjectStore.contains(parentId)) {
                        simpleMemoryObjectStore.remove(parentId);
                    }
                    simpleMemoryObjectStore.store(parentId, (Serializable)Integer.valueOf(partNo));
                    continue;
                }
                catch (ObjectStoreException e) {
                    throw new IOException("Failed pushing back the new part number to cache", e);
                }
            }
            logger.debug("Errors while saving record: \n\t{}", (Object)sv);
            throw new AnalyticsException(sv.toString(), AnalyticsErrorType.TRANSACTION);
        }
        logger.info("Sending data part to Analytics cloud - finished");
    }

    public void startProcessing(PartnerConnection partnerConnection, String parentId) {
        SaveResult[] results;
        logger.info("Tell to Analytics system to start processing of information on edgemart with parentId: {}", (Object)parentId);
        SObject sObject = SObjectBuilder.create("InsightsExternalData").setField("Action", Action.PROCESS.getName()).setId(parentId).build();
        for (SaveResult sv : results = this.updateObject(partnerConnection, sObject)) {
            if (!sv.isSuccess()) {
                logger.error("Failed starting process of data. Errors: {}", (Object)sv);
                throw new AnalyticsException(sv.toString(), AnalyticsErrorType.TRANSACTION);
            }
            logger.info("The processing started successfully.");
        }
    }

    public void delete(PartnerConnection partnerConnection, String dataSetId) {
        DeleteResult[] results;
        for (DeleteResult result : results = this.deleteObject(partnerConnection, dataSetId)) {
            if (!result.isSuccess()) {
                throw new AnalyticsException(result.toString(), AnalyticsErrorType.TRANSACTION);
            }
            logger.info("The deletion of the object ended successfully.");
        }
    }

    private static void logSOAPErrorAndRethrow(String s, Exception e) {
        logger.error(s, (Throwable)e);
        if (e instanceof UnexpectedErrorFault) {
            if (((UnexpectedErrorFault)e).getExceptionCode() == ExceptionCode.INVALID_SESSION_ID) {
                throw new AnalyticsException(((UnexpectedErrorFault)e).getExceptionMessage(), AnalyticsErrorType.INVALID_SESSION);
            }
            throw new AnalyticsException(((UnexpectedErrorFault)e).getExceptionMessage(), AnalyticsErrorType.TRANSACTION);
        }
        if (e instanceof ApiQueryFault) {
            throw new AnalyticsException(((ApiQueryFault)e).getExceptionMessage(), AnalyticsErrorType.ERROR_RESPONSE);
        }
        throw new AnalyticsException(e.getMessage(), AnalyticsErrorType.TRANSACTION);
    }
}

