/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.salesforce.analytics.internal.service.transaction;

import com.sforce.soap.partner.PartnerConnection;
import java.io.IOException;
import org.mule.modules.salesforce.analytics.api.DataSetConnectorNotificationSent;
import org.mule.modules.salesforce.analytics.api.DataSetConnectorOperation;
import org.mule.modules.salesforce.analytics.internal.connection.SalesforceAnalyticsConnection;
import org.mule.modules.salesforce.analytics.internal.service.transaction.AnalyticsUploader;
import org.mule.modules.salesforce.analytics.internal.service.transaction.ParentDTO;
import org.mule.modules.salesforce.analytics.internal.service.transaction.TransactionManager;
import org.mule.runtime.api.store.ObjectStore;

public class AnalyticsTransactionManagerImpl
implements TransactionManager {
    private SalesforceAnalyticsConnection connection;
    private AnalyticsUploader analyticsUploader;

    public AnalyticsTransactionManagerImpl(SalesforceAnalyticsConnection connection) {
        this.connection = connection;
        this.analyticsUploader = new AnalyticsUploader();
    }

    @Override
    public String create(String edgemartAlias, String metadataJson, String format, DataSetConnectorOperation operation, String edgemartContainer, DataSetConnectorNotificationSent notificationSent, String notificationEmail) {
        PartnerConnection partnerConnection = this.connection.getPartnerConnection();
        ParentDTO parentDTO = new ParentDTO();
        parentDTO.setEdgemartAlias(edgemartAlias);
        parentDTO.setEdgemartContainer(edgemartContainer);
        parentDTO.setMetadataJson(metadataJson);
        parentDTO.setFormat(format);
        parentDTO.setNotificationEmail(notificationEmail);
        parentDTO.setNotificationSent(notificationSent != null ? notificationSent.getName() : null);
        parentDTO.setOperation(operation.getName());
        return this.analyticsUploader.createParent(partnerConnection, parentDTO);
    }

    @Override
    public void sendDataPart(String parentId, byte[] dataPart, int dataPartNo, ObjectStore<Integer> simpleMemoryObjectStore) throws IOException {
        PartnerConnection partnerConnection = this.connection.getPartnerConnection();
        this.analyticsUploader.sendDataPart(partnerConnection, parentId, dataPart, dataPartNo, simpleMemoryObjectStore);
    }

    @Override
    public void commit(String parentId) {
        PartnerConnection partnerConnection = this.connection.getPartnerConnection();
        this.analyticsUploader.startProcessing(partnerConnection, parentId);
    }

    @Override
    public void delete(String dataSetId) {
        PartnerConnection partnerConnection = this.connection.getPartnerConnection();
        this.analyticsUploader.delete(partnerConnection, dataSetId);
    }
}

