/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.salesforce.analytics.internal.operation;

import org.apache.commons.lang3.StringUtils;
import org.mule.connectors.atlantic.commons.builder.execution.ExecutionBuilder;
import org.mule.connectors.atlantic.commons.builder.lambda.function.BiFunction;
import org.mule.connectors.commons.template.config.ConnectorConfig;
import org.mule.connectors.commons.template.connection.ConnectorConnection;
import org.mule.connectors.commons.template.operation.ConnectorOperations;
import org.mule.connectors.commons.template.service.ConnectorService;
import org.mule.modules.salesforce.analytics.internal.config.SalesforceAnalyticsConfig;
import org.mule.modules.salesforce.analytics.internal.connection.SalesforceAnalyticsConnection;
import org.mule.modules.salesforce.analytics.internal.error.AnalyticsErrorType;
import org.mule.modules.salesforce.analytics.internal.error.exception.AnalyticsException;
import org.mule.modules.salesforce.analytics.internal.error.exception.InvalidDataSetIDException;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.extension.api.connectivity.oauth.AccessTokenExpiredException;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;

public class AnalyticsOperations<SERVICE extends ConnectorService>
extends ConnectorOperations<SalesforceAnalyticsConfig, SalesforceAnalyticsConnection, SERVICE> {
    protected AnalyticsOperations(BiFunction<SalesforceAnalyticsConfig, SalesforceAnalyticsConnection, SERVICE> serviceConstructor) {
        super(serviceConstructor);
    }

    protected ExecutionBuilder<SERVICE> newExecutionBuilder(SalesforceAnalyticsConfig config, SalesforceAnalyticsConnection connection) {
        return (ExecutionBuilder)((ExecutionBuilder)((ExecutionBuilder)super.newExecutionBuilder((ConnectorConfig)config, (ConnectorConnection)connection).withExceptionHandler(Exception.class, e -> {
            throw new ModuleException(e.getMessage(), (ErrorTypeDefinition)AnalyticsErrorType.UNKNOWN, e);
        })).withExceptionHandler(InvalidDataSetIDException.class, e -> {
            throw new ModuleException(e.getMessage(), (ErrorTypeDefinition)AnalyticsErrorType.INVALID_REQUEST_DATA, e);
        })).withExceptionHandler(AnalyticsException.class, e -> {
            if (e.getType().equals((Object)AnalyticsErrorType.CONNECTIVITY) || e.getType().equals((Object)AnalyticsErrorType.INVALID_SESSION)) {
                if (StringUtils.isNotBlank((CharSequence)connection.getResourceOwnerId())) {
                    throw new AccessTokenExpiredException(connection.getResourceOwnerId());
                }
                throw new ModuleException(e.getMessage(), (ErrorTypeDefinition)AnalyticsErrorType.CONNECTIVITY, (Throwable)new ConnectionException(e.getMessage()));
            }
            throw e;
        });
    }
}

