/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.salesforce.analytics.internal.metadata;

import java.util.Optional;
import java.util.Set;
import org.mule.metadata.api.model.MetadataType;
import org.mule.modules.salesforce.analytics.internal.connection.SalesforceAnalyticsConnection;
import org.mule.modules.salesforce.analytics.internal.error.exception.MetadataException;
import org.mule.modules.salesforce.analytics.internal.service.impl.SalesforceAnalyticsMetadataServiceImpl;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.metadata.MetadataContext;
import org.mule.runtime.api.metadata.MetadataKey;
import org.mule.runtime.api.metadata.MetadataResolvingException;
import org.mule.runtime.api.metadata.resolving.FailureCode;
import org.mule.runtime.api.metadata.resolving.InputTypeResolver;
import org.mule.runtime.api.metadata.resolving.OutputTypeResolver;
import org.mule.runtime.api.metadata.resolving.TypeKeysResolver;

public class SalesforceAnalyticsMetadataResolver
implements InputTypeResolver<String>,
OutputTypeResolver<Object>,
TypeKeysResolver {
    public Set<MetadataKey> getKeys(MetadataContext metadataContext) throws MetadataResolvingException, ConnectionException {
        SalesforceAnalyticsMetadataServiceImpl metadataService = new SalesforceAnalyticsMetadataServiceImpl(this.extractConnection(metadataContext));
        return metadataService.getMetadataKeys();
    }

    public MetadataType getInputMetadata(MetadataContext metadataContext, String metadataKey) throws MetadataResolvingException, ConnectionException {
        SalesforceAnalyticsMetadataServiceImpl metadataService = new SalesforceAnalyticsMetadataServiceImpl(this.extractConnection(metadataContext));
        try {
            return metadataService.getInputMetadata(metadataKey, metadataContext);
        }
        catch (MetadataException e) {
            throw new MetadataResolvingException(e.getMessage(), FailureCode.UNKNOWN, (Throwable)e);
        }
    }

    public MetadataType getOutputType(MetadataContext context, Object key) throws MetadataResolvingException, ConnectionException {
        return context.getTypeBuilder().voidType().build();
    }

    public String getResolverName() {
        return SalesforceAnalyticsMetadataResolver.class.getName();
    }

    public String getCategoryName() {
        return "SalesforceAnalyticsMetadataCategory";
    }

    private SalesforceAnalyticsConnection extractConnection(MetadataContext metadataContext) throws ConnectionException, MetadataResolvingException {
        Optional optionalConnection = metadataContext.getConnection();
        return (SalesforceAnalyticsConnection)optionalConnection.orElseThrow(() -> new MetadataResolvingException("No connection available.", FailureCode.UNKNOWN));
    }
}

