/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.salesforce.analytics.internal.connection.service;

import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.KeyStore;
import java.text.MessageFormat;
import java.util.UUID;
import net.shibboleth.utilities.java.support.xml.SerializeSupport;
import org.apache.commons.codec.binary.Base64;
import org.joda.time.DateTime;
import org.mule.modules.salesforce.analytics.internal.connection.service.SignerService;
import org.mule.modules.salesforce.analytics.internal.error.AnalyticsErrorType;
import org.mule.modules.salesforce.analytics.internal.error.exception.AnalyticsException;
import org.opensaml.core.config.InitializationException;
import org.opensaml.core.config.InitializationService;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectBuilderFactory;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.io.Marshaller;
import org.opensaml.core.xml.io.MarshallerFactory;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.saml.common.SAMLObjectBuilder;
import org.opensaml.saml.common.SAMLVersion;
import org.opensaml.saml.common.SignableSAMLObject;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.Audience;
import org.opensaml.saml.saml2.core.AudienceRestriction;
import org.opensaml.saml.saml2.core.AuthnContext;
import org.opensaml.saml.saml2.core.AuthnContextClassRef;
import org.opensaml.saml.saml2.core.AuthnStatement;
import org.opensaml.saml.saml2.core.Conditions;
import org.opensaml.saml.saml2.core.Issuer;
import org.opensaml.saml.saml2.core.NameID;
import org.opensaml.saml.saml2.core.Subject;
import org.opensaml.saml.saml2.core.SubjectConfirmation;
import org.opensaml.saml.saml2.core.SubjectConfirmationData;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class OAuthTokenGeneratorService {
    private static final String ENCODING = "UTF-8";
    private static final String JWT_ALLOWED_ALG = "SHA256WithRSA";
    private SignerService signerService = new SignerService();

    public String generateSAMLToken(String issuer, String principal, String recipient, String audienceURI, InputStream keyStoreStream, char[] storePass) {
        String token;
        try {
            InitializationService.initialize();
            XMLObjectBuilderFactory xmlObjectBuilderFactory = XMLObjectProviderRegistrySupport.getBuilderFactory();
            SAMLObjectBuilder nameIdBuilder = (SAMLObjectBuilder)xmlObjectBuilderFactory.getBuilder(NameID.DEFAULT_ELEMENT_NAME);
            NameID nameId = (NameID)nameIdBuilder.buildObject();
            nameId.setValue(principal);
            nameId.setFormat("urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified");
            SAMLObjectBuilder confirmationMethodBuilder = (SAMLObjectBuilder)xmlObjectBuilderFactory.getBuilder(SubjectConfirmationData.DEFAULT_ELEMENT_NAME);
            SubjectConfirmationData confirmationMethod = (SubjectConfirmationData)confirmationMethodBuilder.buildObject();
            DateTime oneMinuteEarly = new DateTime().minusMinutes(1);
            DateTime oneMinuteEarlyPlus5 = oneMinuteEarly.plusMinutes(5);
            confirmationMethod.setNotOnOrAfter(oneMinuteEarlyPlus5);
            confirmationMethod.setRecipient(recipient);
            SAMLObjectBuilder subjectConfirmationBuilder = (SAMLObjectBuilder)xmlObjectBuilderFactory.getBuilder(SubjectConfirmation.DEFAULT_ELEMENT_NAME);
            SubjectConfirmation subjectConfirmation = (SubjectConfirmation)subjectConfirmationBuilder.buildObject();
            subjectConfirmation.setMethod("urn:oasis:names:tc:SAML:2.0:cm:bearer");
            subjectConfirmation.setSubjectConfirmationData(confirmationMethod);
            SAMLObjectBuilder subjectBuilder = (SAMLObjectBuilder)xmlObjectBuilderFactory.getBuilder(Subject.DEFAULT_ELEMENT_NAME);
            Subject subject = (Subject)subjectBuilder.buildObject();
            subject.setNameID(nameId);
            subject.getSubjectConfirmations().add(subjectConfirmation);
            SAMLObjectBuilder authContextClassRefBuilder = (SAMLObjectBuilder)xmlObjectBuilderFactory.getBuilder(AuthnContextClassRef.DEFAULT_ELEMENT_NAME);
            AuthnContextClassRef authnContextClassRef = (AuthnContextClassRef)authContextClassRefBuilder.buildObject();
            authnContextClassRef.setAuthnContextClassRef("urn:oasis:names:tc:SAML:2.0:ac:classes:unspecified");
            SAMLObjectBuilder authContextBuilder = (SAMLObjectBuilder)xmlObjectBuilderFactory.getBuilder(AuthnContext.DEFAULT_ELEMENT_NAME);
            AuthnContext authnContext = (AuthnContext)authContextBuilder.buildObject();
            authnContext.setAuthnContextClassRef(authnContextClassRef);
            SAMLObjectBuilder authStatementBuilder = (SAMLObjectBuilder)xmlObjectBuilderFactory.getBuilder(AuthnStatement.DEFAULT_ELEMENT_NAME);
            AuthnStatement authnStatement = (AuthnStatement)authStatementBuilder.buildObject();
            authnStatement.setAuthnInstant(oneMinuteEarly);
            authnStatement.setAuthnContext(authnContext);
            SAMLObjectBuilder audienceBuilder = (SAMLObjectBuilder)xmlObjectBuilderFactory.getBuilder(Audience.DEFAULT_ELEMENT_NAME);
            Audience audience = (Audience)audienceBuilder.buildObject();
            audience.setAudienceURI(audienceURI);
            SAMLObjectBuilder audienceRestrictionBuilder = (SAMLObjectBuilder)xmlObjectBuilderFactory.getBuilder(AudienceRestriction.DEFAULT_ELEMENT_NAME);
            AudienceRestriction audienceRestriction = (AudienceRestriction)audienceRestrictionBuilder.buildObject();
            audienceRestriction.getAudiences().add(audience);
            SAMLObjectBuilder conditionsBuilder = (SAMLObjectBuilder)xmlObjectBuilderFactory.getBuilder(Conditions.DEFAULT_ELEMENT_NAME);
            Conditions conditions = (Conditions)conditionsBuilder.buildObject();
            conditions.setNotBefore(oneMinuteEarly);
            conditions.setNotOnOrAfter(oneMinuteEarlyPlus5);
            conditions.getConditions().add(audienceRestriction);
            SAMLObjectBuilder issuerBuilder = (SAMLObjectBuilder)xmlObjectBuilderFactory.getBuilder(Issuer.DEFAULT_ELEMENT_NAME);
            Issuer issuerXmlObject = (Issuer)issuerBuilder.buildObject();
            issuerXmlObject.setFormat("urn:oasis:names:tc:SAML:2.0:nameid-format:entity");
            issuerXmlObject.setValue(issuer);
            SAMLObjectBuilder assertionBuilder = (SAMLObjectBuilder)xmlObjectBuilderFactory.getBuilder(Assertion.DEFAULT_ELEMENT_NAME);
            Assertion assertion = (Assertion)assertionBuilder.buildObject();
            assertion.setIssuer(issuerXmlObject);
            assertion.setIssueInstant(oneMinuteEarly);
            assertion.setVersion(SAMLVersion.VERSION_20);
            assertion.setSubject(subject);
            assertion.getAuthnStatements().add(authnStatement);
            assertion.setConditions(conditions);
            assertion.setID(UUID.randomUUID().toString());
            this.validateKeystoreInfo(keyStoreStream, storePass);
            this.signerService.signSAMLObject((SignableSAMLObject)assertion, keyStoreStream, KeyStore.getDefaultType(), storePass);
            MarshallerFactory marshallerFactory = XMLObjectProviderRegistrySupport.getMarshallerFactory();
            Marshaller marshaller = marshallerFactory.getMarshaller((XMLObject)assertion);
            Element element = marshaller.marshall((XMLObject)assertion);
            token = Base64.encodeBase64URLSafeString((byte[])SerializeSupport.nodeToString((Node)element).getBytes(ENCODING));
        }
        catch (UnsupportedEncodingException | InitializationException | MarshallingException e) {
            throw new AnalyticsException("Failed generating SAML token " + e.getMessage(), AnalyticsErrorType.CONNECTIVITY);
        }
        return token;
    }

    private void validateKeystoreInfo(InputStream keyStoreStream, char[] storePass) {
        if (keyStoreStream == null) {
            throw new AnalyticsException("Invalid key store stream. It can not be null.", AnalyticsErrorType.CONNECTIVITY);
        }
        if (storePass == null) {
            throw new AnalyticsException("Invalid key store password. It can not be null.", AnalyticsErrorType.CONNECTIVITY);
        }
    }

    public String generateJWTToken(String issuer, String principal, String audienceURI, InputStream keyStoreStream, char[] storePass) {
        String header = "{\"alg\":\"RS256\"}";
        String claimTemplate = "'{'\"iss\": \"{0}\", \"prn\": \"{1}\", \"aud\": \"{2}\", \"exp\": \"{3}\"'}'";
        StringBuilder token = new StringBuilder();
        try {
            token.append(Base64.encodeBase64URLSafeString((byte[])header.getBytes(ENCODING)));
            token.append(".");
            String[] claimArray = new String[]{issuer, principal, audienceURI, Long.toString(System.currentTimeMillis() / 1000L + 300L)};
            MessageFormat claims = new MessageFormat(claimTemplate);
            String payload = claims.format(claimArray);
            token.append(Base64.encodeBase64URLSafeString((byte[])payload.getBytes(ENCODING)));
            this.validateKeystoreInfo(keyStoreStream, storePass);
            String base64SignedPayload = Base64.encodeBase64URLSafeString((byte[])this.signerService.signPayload(JWT_ALLOWED_ALG, token.toString().getBytes(ENCODING), keyStoreStream, KeyStore.getDefaultType(), storePass));
            token.append(".");
            token.append(base64SignedPayload);
        }
        catch (UnsupportedEncodingException e) {
            throw new AnalyticsException("Failed generating JWT token " + e.getMessage(), AnalyticsErrorType.CONNECTIVITY);
        }
        return token.toString();
    }
}

