/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.salesforce.analytics.internal.connection.service;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import java.util.zip.GZIPInputStream;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.core.api.util.StringUtils;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.domain.entity.ByteArrayHttpEntity;
import org.mule.runtime.http.api.domain.entity.EmptyHttpEntity;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.request.HttpRequestBuilder;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;

public class HttpClientService {
    private static final String COOKIE_HEADER = "Cookie";
    private static final int RESPONSE_TIMEOUT = 5000;
    private HttpClient httpClient;

    public HttpClientService(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public InputStream sendPost(String uri, String requestBody, Map<String, String> headers, Map<String, String> cookies) throws IOException, TimeoutException {
        MultiMap requestHeaders = new MultiMap();
        if (headers != null) {
            requestHeaders.putAll(headers);
        }
        this.setCookies((MultiMap<String, String>)requestHeaders, cookies);
        Object httpEntity = !StringUtils.isEmpty((String)requestBody) ? new ByteArrayHttpEntity(requestBody.getBytes(Charset.forName("UTF-8"))) : new EmptyHttpEntity();
        HttpRequest request = ((HttpRequestBuilder)((HttpRequestBuilder)HttpRequest.builder().method(HttpConstants.Method.POST).uri(uri).entity((HttpEntity)httpEntity)).headers(requestHeaders)).build();
        return this.executeMethod(request);
    }

    private InputStream executeMethod(HttpRequest request) throws IOException, TimeoutException {
        HttpResponse response = this.httpClient.send(request, 5000, true, null);
        int statusCode = response.getStatusCode();
        if (statusCode != 200) {
            HttpEntity httpEntity = response.getEntity();
            InputStream responseStream = httpEntity != null ? httpEntity.getContent() : null;
            throw new IOException(String.format("Invalid status code: %d, response body: %s", statusCode, responseStream != null ? IOUtils.toString((InputStream)responseStream) : null));
        }
        return this.getResponseStream(response);
    }

    private void setCookies(MultiMap<String, String> requestHeaders, Map<String, String> cookies) {
        if (cookies != null) {
            StringBuilder cookiesValue = new StringBuilder();
            for (Map.Entry<String, String> cookie : cookies.entrySet()) {
                cookiesValue.append(String.format("%s=%s", cookie.getKey(), cookie.getValue()));
                cookiesValue.append(";");
            }
            if (cookiesValue.length() != 0) {
                cookiesValue.deleteCharAt(cookiesValue.length() - 1);
                requestHeaders.put((Object)COOKIE_HEADER, (Object)cookiesValue.toString());
            }
        }
    }

    private InputStream getResponseStream(HttpResponse method) throws IOException {
        InputStream result = null;
        HttpEntity responseEntity = method.getEntity();
        if (responseEntity != null) {
            result = responseEntity.getContent();
        }
        if (result == null || result.available() == 0) {
            throw new IOException("Empty stream came as response");
        }
        return new GZIPInputStream(result);
    }
}

