/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.salesforce.analytics.internal.connection.service;

import com.sforce.soap.partner.Connector;
import com.sforce.soap.partner.PartnerConnection;
import com.sforce.ws.ConnectionException;
import com.sforce.ws.ConnectorConfig;
import java.text.MessageFormat;
import org.mule.modules.salesforce.analytics.internal.connection.param.bundle.BaseOAuthParamsBundle;
import org.mule.modules.salesforce.analytics.internal.connection.service.AbstractConnectionService;
import org.mule.modules.salesforce.analytics.internal.util.ConnectionUtil;

public class AbstractOAuthConnectionService
extends AbstractConnectionService {
    private static final String COULD_NOT_EXTRACT_FIELD = "Not able to extract \"%s\" neither from response returned on callback nor from an object store.";

    protected PartnerConnection postAuthorization(BaseOAuthParamsBundle bundle, String oAuth2AccessToken, String instanceUrl) throws org.mule.runtime.api.connection.ConnectionException {
        this.checkExistenceOfRequiredFieldValues(oAuth2AccessToken, instanceUrl);
        return this.createPartnerConnection(bundle, oAuth2AccessToken, instanceUrl);
    }

    private PartnerConnection createPartnerConnection(BaseOAuthParamsBundle bundle, String oAuth2AccessToken, String instanceUrl) throws org.mule.runtime.api.connection.ConnectionException {
        PartnerConnection salesforcePartnerConnection;
        ConnectorConfig config = new ConnectorConfig();
        this.fillConnectionConfig(config, bundle);
        config.setSessionId(oAuth2AccessToken);
        String serviceEndpoint = String.format("%s/services/Soap/u/53.0", instanceUrl);
        config.setServiceEndpoint(serviceEndpoint);
        config.setSslContext(bundle.getSslContext());
        try {
            salesforcePartnerConnection = Connector.newConnection((ConnectorConfig)config);
        }
        catch (ConnectionException e) {
            throw new org.mule.runtime.api.connection.ConnectionException((Throwable)e);
        }
        this.switchEndpointToMutualTlsIfNeeded(salesforcePartnerConnection);
        return salesforcePartnerConnection;
    }

    private void checkExistenceOfRequiredFieldValues(String oAuth2AccessToken, String instanceUrl) throws org.mule.runtime.api.connection.ConnectionException {
        if (oAuth2AccessToken == null) {
            throw new org.mule.runtime.api.connection.ConnectionException(MessageFormat.format(COULD_NOT_EXTRACT_FIELD, "accessToken"));
        }
        if (instanceUrl == null) {
            throw new org.mule.runtime.api.connection.ConnectionException(MessageFormat.format(COULD_NOT_EXTRACT_FIELD, "instanceId"));
        }
    }

    private void fillConnectionConfig(ConnectorConfig connectorConfig, BaseOAuthParamsBundle bundle) {
        connectorConfig.setManualLogin(false);
        connectorConfig.setCompression(false);
        ConnectionUtil.enrichWithProxyConfig(connectorConfig, bundle.getProxySettingsParams());
        ConnectionUtil.enrichWithConnectionConfig(connectorConfig, bundle.getoAuthAdvancedParams());
    }
}

