/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.salesforce.analytics.internal.connection.provider;

import com.sforce.soap.partner.PartnerConnection;
import org.mule.modules.salesforce.analytics.internal.connection.param.OAuth2TokenBearerParams;
import org.mule.modules.salesforce.analytics.internal.connection.param.bundle.OAuth2TokenBearerParamsBundle;
import org.mule.modules.salesforce.analytics.internal.connection.provider.AbstractOAuthBearerConnectionProvider;
import org.mule.modules.salesforce.analytics.internal.connection.service.GrantType;
import org.mule.modules.salesforce.analytics.internal.connection.service.OAuthTokenBearerService;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Placement;

@Alias(value="oauth-saml")
@DisplayName(value="OAuth 2.0 SAML Bearer")
public class OAuthSAMLConnectionProvider
extends AbstractOAuthBearerConnectionProvider {
    @ParameterGroup(name="Connection")
    @Placement(order=1)
    private OAuth2TokenBearerParams oAuth2TokenBearerParams;

    @Override
    public PartnerConnection createPartnerConnection() throws ConnectionException {
        OAuth2TokenBearerParamsBundle oAuth2TokenBearerParamsBundle = new OAuth2TokenBearerParamsBundle(this.tlsContextFactory, this.getSslContext(this.tlsContextFactory));
        oAuth2TokenBearerParamsBundle.setoAuth2TokenBearerParams(this.oAuth2TokenBearerParams);
        oAuth2TokenBearerParamsBundle.setoAuthAdvancedParams(this.oAuthAdvancedParams);
        oAuth2TokenBearerParamsBundle.setProxySettingsParams(this.proxySettingsParams);
        OAuthTokenBearerService oAuthTokenBearerService = this.connectionServiceFactory.oAuthTokenBearerService(this.httpService, oAuth2TokenBearerParamsBundle);
        return oAuthTokenBearerService.login(GrantType.SAML);
    }

    public OAuth2TokenBearerParams getoAuth2TokenBearerParams() {
        return this.oAuth2TokenBearerParams;
    }

    public void setoAuth2TokenBearerParams(OAuth2TokenBearerParams oAuth2TokenBearerParams) {
        this.oAuth2TokenBearerParams = oAuth2TokenBearerParams;
    }
}

