/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.salesforce.analytics.internal.util.csv;

import java.util.Map;
import java.util.Set;
import org.mule.modules.salesforce.analytics.internal.error.exception.WriterException;
import org.mule.modules.salesforce.analytics.internal.metadata.DataType;
import org.mule.modules.salesforce.analytics.internal.metadata.FieldMetadata;
import org.mule.modules.salesforce.analytics.internal.metadata.FileFormat;
import org.mule.modules.salesforce.analytics.internal.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapToCSVLineTransformer {
    private static final Logger logger = LoggerFactory.getLogger(MapToCSVLineTransformer.class);
    private Set<String> orderOfHeaders;
    private Map<String, FieldMetadata> mappings;
    private FileFormat fileFormat;

    public MapToCSVLineTransformer(Set<String> orderOfHeaders, FileFormat fileFormat, Map<String, FieldMetadata> mappings) {
        this.orderOfHeaders = orderOfHeaders;
        this.fileFormat = fileFormat;
        this.mappings = mappings;
    }

    public void setOrderOfHeaders(Set<String> orderOfHeaders) {
        this.orderOfHeaders = orderOfHeaders;
    }

    public void setMappings(Map<String, FieldMetadata> mappings) {
        this.mappings = mappings;
    }

    public String transformRecord(Map<String, String> valuesMap) throws WriterException {
        this.validateProvidedMappings();
        this.validateHeaderOrder();
        this.validateFileFormat();
        String[] line = new String[this.orderOfHeaders.size()];
        int unknownFields = 0;
        int index = 0;
        for (String headerName : this.orderOfHeaders) {
            String fieldName = StringUtil.unquote(headerName);
            String fieldValue = StringUtil.unquote(valuesMap.get(headerName));
            FieldMetadata fieldTypeInfo = this.mappings.get(fieldName);
            if (fieldTypeInfo != null) {
                DataType fieldType = fieldTypeInfo.getType();
                if (fieldType == DataType.DATE) {
                    line[index] = StringUtil.quote(fieldValue);
                } else if (fieldType == DataType.TEXT && fieldTypeInfo.getIsMultiValue() != null && fieldTypeInfo.getIsMultiValue().booleanValue()) {
                    line[index] = StringUtil.quote(fieldValue);
                } else if (fieldType == DataType.TEXT) {
                    line[index] = StringUtil.quote(fieldValue);
                } else if (fieldType == DataType.NUMERIC) {
                    line[index] = StringUtil.quote(fieldValue);
                } else {
                    logger.warn("Unknown field type: {} for field: {}", (Object)fieldTypeInfo, (Object)fieldName);
                    ++unknownFields;
                }
            } else {
                line[index] = StringUtil.quote("");
                logger.warn("No metadata found for field: {}", (Object)fieldName);
            }
            ++index;
        }
        return this.getCsvRecordLine(line, unknownFields);
    }

    private void validateProvidedMappings() throws WriterException {
        if (this.mappings == null) {
            throw new WriterException("No mappings provided");
        }
    }

    private void validateHeaderOrder() throws WriterException {
        if (this.orderOfHeaders == null) {
            throw new WriterException("No header order set provided");
        }
    }

    private void validateFileFormat() throws WriterException {
        if (this.fileFormat == null) {
            throw new WriterException("No FileFormat provided");
        }
    }

    private String getCsvRecordLine(String[] line, Integer unknownFields) {
        StringBuilder lineBuilder = new StringBuilder();
        for (int i = 0; i < line.length; ++i) {
            if (line[i] != null) {
                lineBuilder.append(line[i]);
                if (i >= line.length - unknownFields - 1) continue;
                lineBuilder.append(this.fileFormat.getFieldsDelimitedBy());
                continue;
            }
            if (i >= line.length - unknownFields - 1) continue;
            lineBuilder.append(this.fileFormat.getFieldsDelimitedBy());
        }
        return lineBuilder.toString();
    }

    public FileFormat getFileFormat() {
        return this.fileFormat != null ? this.fileFormat : new FileFormat();
    }

    public void setFileFormat(FileFormat fileFormat) {
        this.fileFormat = fileFormat;
    }
}

