/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.salesforce.analytics.internal.util;

import com.sforce.soap.partner.QueryResult;
import com.sforce.ws.ConnectionException;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.concurrent.locks.Lock;
import org.mule.modules.salesforce.analytics.internal.connection.SalesforceAnalyticsConnection;
import org.mule.modules.salesforce.analytics.internal.error.AnalyticsErrorType;
import org.mule.modules.salesforce.analytics.internal.error.exception.AnalyticsException;
import org.mule.modules.salesforce.analytics.internal.service.transaction.TransactionManager;
import org.mule.runtime.api.store.ObjectStore;
import org.mule.runtime.api.store.ObjectStoreException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnalyticsOutputStream
extends OutputStream {
    private static final Logger logger = LoggerFactory.getLogger(AnalyticsOutputStream.class);
    private static final String INSIGHTS_EXTERNAL_DATA_PART_QUERY = "SELECT PartNumber FROM InsightsExternalDataPart WHERE InsightsExternalDataId = '%s'";
    private static final String PART_NUMBER = "PartNumber";
    private ByteBuffer byteBuffer;
    private final String dataSetId;
    private int bufferSize;
    private final TransactionManager transactionManager;
    private final ObjectStore<Integer> partNoObjectStore;
    private final Lock partUploadLock;
    private SalesforceAnalyticsConnection connection;

    public AnalyticsOutputStream(String dataSetId, int bufferSize, TransactionManager transactionManager, SalesforceAnalyticsConnection connection, ObjectStore<Integer> partNoObjectStore, Lock partUploadLock) {
        this.dataSetId = dataSetId;
        this.transactionManager = transactionManager;
        this.partNoObjectStore = partNoObjectStore;
        this.partUploadLock = partUploadLock;
        this.connection = connection;
        if (bufferSize <= 0) {
            throw new IllegalArgumentException("Invalid buffer size: " + bufferSize);
        }
        this.bufferSize = bufferSize;
        this.byteBuffer = ByteBuffer.allocate(this.bufferSize);
    }

    @Override
    public void write(int b) throws IOException {
        this.byteBuffer.put((byte)b);
        if (this.byteBuffer.position() == this.bufferSize) {
            logger.debug("Buffer full. Flush it. Buffer size: {} bytes.", (Object)this.bufferSize);
            logger.warn("The size of data provided for processing in one step exceeded the maximum size of one chunk allowed by Analytics Cloud System. In order to optimize the memory used you should decrease the size of data provided in one step.");
            this.flush();
        }
    }

    @Override
    public void flush() throws IOException {
        byte[] byteContent = this.getByteContent(this.byteBuffer);
        Integer partNo = null;
        try {
            logger.debug("Thread: {} is trying to lock the instance: {} in order to use object store: {}", new Object[]{Thread.currentThread().getName(), this.partUploadLock, this.partNoObjectStore});
            this.partUploadLock.lock();
            partNo = this.computePartNumber();
            try {
                this.transactionManager.sendDataPart(this.dataSetId, byteContent, partNo, this.partNoObjectStore);
            }
            finally {
                logger.debug("Position in buffer before flush: {}", (Object)this.byteBuffer.position());
                this.byteBuffer.clear();
                logger.debug("Position in buffer after flush: {}", (Object)this.byteBuffer.position());
            }
        }
        catch (ObjectStoreException e) {
            try {
                throw new IOException(e.getMessage());
            }
            catch (Throwable throwable) {
                logger.debug("Thread: {} is releasing the lock on instance: {} in order to use object store: {}", new Object[]{Thread.currentThread().getName(), this.partUploadLock, this.partNoObjectStore});
                this.partUploadLock.unlock();
                throw throwable;
            }
        }
        logger.debug("Thread: {} is releasing the lock on instance: {} in order to use object store: {}", new Object[]{Thread.currentThread().getName(), this.partUploadLock, this.partNoObjectStore});
        this.partUploadLock.unlock();
    }

    private byte[] getByteContent(ByteBuffer byteBuffer) {
        byte[] content = new byte[byteBuffer.position()];
        int i = 0;
        byteBuffer.flip();
        while (byteBuffer.hasRemaining()) {
            content[i++] = byteBuffer.get();
        }
        return content;
    }

    @Override
    public void close() throws IOException {
        if (this.byteBuffer.position() > 0) {
            this.flush();
        }
    }

    private Integer computePartNumber() throws ObjectStoreException {
        if (this.partNoObjectStore.contains(this.dataSetId)) {
            return (Integer)this.partNoObjectStore.retrieve(this.dataSetId) + 1;
        }
        try {
            QueryResult queryResult = this.connection.getPartnerConnection().query(String.format(INSIGHTS_EXTERNAL_DATA_PART_QUERY, this.dataSetId));
            if (queryResult.getRecords().length == 0) {
                return 0;
            }
            return Integer.parseInt((String)queryResult.getRecords()[0].getSObjectField(PART_NUMBER));
        }
        catch (ConnectionException e) {
            throw new AnalyticsException(AnalyticsErrorType.CONNECTIVITY, e);
        }
    }
}

