/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.salesforce.analytics.internal.service.impl;

import com.sforce.soap.partner.QueryResult;
import com.sforce.soap.partner.sobject.SObject;
import com.sforce.ws.ConnectionException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.mule.metadata.api.builder.ObjectTypeBuilder;
import org.mule.metadata.api.model.MetadataType;
import org.mule.modules.salesforce.analytics.internal.connection.SalesforceAnalyticsConnection;
import org.mule.modules.salesforce.analytics.internal.error.AnalyticsErrorType;
import org.mule.modules.salesforce.analytics.internal.error.exception.AnalyticsException;
import org.mule.modules.salesforce.analytics.internal.error.exception.MetadataException;
import org.mule.modules.salesforce.analytics.internal.metadata.AnalyticsMetadataInfo;
import org.mule.modules.salesforce.analytics.internal.metadata.FieldMetadata;
import org.mule.modules.salesforce.analytics.internal.service.SalesforceAnalyticsMetadataService;
import org.mule.modules.salesforce.analytics.internal.util.MetadataUtil;
import org.mule.runtime.api.metadata.MetadataContext;
import org.mule.runtime.api.metadata.MetadataKey;
import org.mule.runtime.api.metadata.MetadataKeyBuilder;

public class SalesforceAnalyticsMetadataServiceImpl
implements SalesforceAnalyticsMetadataService {
    private SalesforceAnalyticsConnection connection;
    private static final String RECORD_OBJECT_TYPE = "Record";
    private static final String METADATA_KEYS_QUERY = "SELECT Id, EdgemartAlias FROM InsightsExternalData WHERE Action = 'None'";
    private static final String EDGEMART_ALIAS = "EdgemartAlias";

    public SalesforceAnalyticsMetadataServiceImpl(SalesforceAnalyticsConnection connection) {
        this.connection = connection;
    }

    @Override
    public Set<MetadataKey> getMetadataKeys() {
        HashSet<MetadataKey> metadataKeys = new HashSet<MetadataKey>();
        try {
            QueryResult queryResult = this.connection.getPartnerConnection().queryAll(METADATA_KEYS_QUERY);
            for (SObject sObject : queryResult.getRecords()) {
                metadataKeys.add(MetadataKeyBuilder.newKey((String)sObject.getId()).withDisplayName(sObject.getField(EDGEMART_ALIAS).toString()).build());
            }
        }
        catch (ConnectionException e) {
            throw new AnalyticsException(AnalyticsErrorType.CONNECTIVITY, e);
        }
        return metadataKeys;
    }

    @Override
    public MetadataType getInputMetadata(String entityKey, MetadataContext metadataContext) throws MetadataException {
        try {
            AnalyticsMetadataInfo fieldMetadataInfo = MetadataUtil.getAnalyticsMetadata(this.connection, entityKey);
            List<FieldMetadata> metadataFields = fieldMetadataInfo.getObjects().get(0).getFields();
            ObjectTypeBuilder objectTypeBuilder = metadataContext.getTypeBuilder().objectType().id(RECORD_OBJECT_TYPE);
            for (FieldMetadata metadataField : metadataFields) {
                MetadataUtil.addSimpleField(objectTypeBuilder, metadataField);
            }
            return objectTypeBuilder.build();
        }
        catch (ConnectionException e) {
            throw new MetadataException(e.getMessage(), e);
        }
    }
}

