/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.salesforce.analytics.internal.metadata;

public enum Format {
    BINARY("Binary"),
    CSV("CSV");

    private final String name;

    private Format(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public static Format getFormat(String name) {
        Format resultFormat = null;
        for (Format format : Format.values()) {
            if (!format.getName().equals(name)) continue;
            resultFormat = format;
        }
        return resultFormat;
    }

    public static String formats() {
        StringBuilder stringBuilder = new StringBuilder("[");
        for (Format format : Format.values()) {
            stringBuilder.append(format.getName());
            stringBuilder.append(",");
        }
        stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

