/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.salesforce.analytics.internal.error.exception;

import java.util.Optional;
import org.mule.modules.salesforce.analytics.internal.error.AnalyticsErrorType;
import org.mule.modules.salesforce.analytics.internal.error.exception.ErrorContent;
import org.mule.runtime.api.exception.ErrorMessageAwareException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;

public class AnalyticsException
extends ModuleException
implements ErrorMessageAwareException {
    private final Message message;

    public AnalyticsException(ErrorTypeDefinition code, Throwable cause) {
        super(code, cause);
        this.message = this.buildErrorMessage(cause.getMessage(), (ErrorTypeDefinition<AnalyticsErrorType>)code);
    }

    public AnalyticsException(String message, ErrorTypeDefinition code) {
        super(String.format("%s: %s", code, message), code);
        this.message = this.buildErrorMessage(message, (ErrorTypeDefinition<AnalyticsErrorType>)code);
    }

    public AnalyticsException(String message, ErrorTypeDefinition code, Throwable cause) {
        super(String.format("%s: %s", code, message), code, cause);
        this.message = this.buildErrorMessage(message, (ErrorTypeDefinition<AnalyticsErrorType>)code);
    }

    public Message getErrorMessage() {
        return Optional.ofNullable(this.message).orElse(null);
    }

    private Message buildErrorMessage(String message, ErrorTypeDefinition<AnalyticsErrorType> code) {
        return Message.builder().payload(new TypedValue((Object)new ErrorContent(code.getType(), message), DataType.OBJECT)).build();
    }
}

