/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.salesforce.analytics.internal.connection.service;

import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import org.mule.modules.salesforce.analytics.internal.error.AnalyticsErrorType;
import org.mule.modules.salesforce.analytics.internal.error.exception.AnalyticsException;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.saml.common.SignableSAMLObject;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.x509.BasicX509Credential;
import org.opensaml.xmlsec.SecurityConfigurationSupport;
import org.opensaml.xmlsec.SignatureSigningConfiguration;
import org.opensaml.xmlsec.SignatureSigningParameters;
import org.opensaml.xmlsec.algorithm.AlgorithmSupport;
import org.opensaml.xmlsec.signature.support.SignatureSupport;
import org.opensaml.xmlsec.signature.support.Signer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignerService {
    private static final Logger logger = LoggerFactory.getLogger(SignerService.class);

    public byte[] signPayload(String allowedAlg, byte[] payload, InputStream keyStoreStream, String keyStoreType, char[] storePass) {
        byte[] result;
        try {
            KeyStore keystore = this.loadKeyStore(keyStoreStream, keyStoreType, storePass);
            String aliasName = this.extractAlias(keystore);
            PrivateKey privateKey = (PrivateKey)keystore.getKey(aliasName, storePass);
            Certificate cert = keystore.getCertificate(aliasName);
            String signAlgorithm = this.validateCertificateAgainstAllowedAlg(allowedAlg, cert);
            Signature signature = Signature.getInstance(signAlgorithm);
            signature.initSign(privateKey);
            signature.update(payload);
            result = signature.sign();
        }
        catch (InvalidKeyException | KeyStoreException | NoSuchAlgorithmException | SignatureException | UnrecoverableKeyException e) {
            throw new AnalyticsException("Unable to load key store file. Message: " + e.getMessage(), AnalyticsErrorType.CONNECTIVITY, e);
        }
        return result;
    }

    private String validateCertificateAgainstAllowedAlg(String allowedAlg, Certificate cert) {
        this.validateCertificateTypeAgainstX509(cert);
        return this.validateCerticateAlgorithm(allowedAlg, (X509Certificate)cert);
    }

    private String validateCerticateAlgorithm(String allowedAlg, X509Certificate cert) {
        String signAlgorithm = cert.getSigAlgName();
        if (!allowedAlg.equalsIgnoreCase(signAlgorithm)) {
            throw new AnalyticsException(String.format("Algorithm used by keystore: \"%s\", not allowed. Expected algorithm: \"%s\"", signAlgorithm, allowedAlg), AnalyticsErrorType.CONNECTIVITY);
        }
        return signAlgorithm;
    }

    private void validateCertificateTypeAgainstX509(Certificate cert) {
        if (!(cert instanceof X509Certificate)) {
            throw new AnalyticsException("Unknown certificate type: " + cert.getClass().getName(), AnalyticsErrorType.CONNECTIVITY);
        }
    }

    private KeyStore loadKeyStore(InputStream keyStoreStream, String keyStoreType, char[] storePass) {
        KeyStore keystore;
        try {
            keystore = KeyStore.getInstance(keyStoreType);
            keystore.load(keyStoreStream, storePass);
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new AnalyticsException("Unable to load key store file. Message: " + e.getMessage(), AnalyticsErrorType.CONNECTIVITY, e);
        }
        return keystore;
    }

    private String extractAlias(KeyStore keyStore) {
        String aliasName;
        block4: {
            try {
                Enumeration<String> aliases = keyStore.aliases();
                if (aliases.hasMoreElements()) {
                    aliasName = aliases.nextElement();
                    if (aliases.hasMoreElements()) {
                        logger.warn("There are more than one alias, picked first one with name: {}", (Object)aliasName);
                    }
                    break block4;
                }
                throw new AnalyticsException("Keystore contains no certificate", AnalyticsErrorType.CONNECTIVITY);
            }
            catch (KeyStoreException e) {
                throw new AnalyticsException(e.getMessage(), AnalyticsErrorType.CONNECTIVITY);
            }
        }
        return aliasName;
    }

    public void signSAMLObject(SignableSAMLObject samlObject, InputStream keyStoreStream, String keyStoreType, char[] storePass) {
        try {
            KeyStore keystore = this.loadKeyStore(keyStoreStream, keyStoreType, storePass);
            String aliasName = this.extractAlias(keystore);
            PrivateKey privateKey = (PrivateKey)keystore.getKey(aliasName, storePass);
            X509Certificate x509Certificate = null;
            Certificate cert = keystore.getCertificate(aliasName);
            if (!(cert instanceof X509Certificate)) {
                throw new IOException("Unknown certificate type: " + cert.getClass().getName());
            }
            x509Certificate = (X509Certificate)cert;
            BasicX509Credential credential = new BasicX509Credential(x509Certificate, privateKey);
            org.opensaml.xmlsec.signature.Signature signature = (org.opensaml.xmlsec.signature.Signature)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilder(org.opensaml.xmlsec.signature.Signature.DEFAULT_ELEMENT_NAME).buildObject(org.opensaml.xmlsec.signature.Signature.DEFAULT_ELEMENT_NAME);
            signature.setSigningCredential((Credential)credential);
            SignatureSigningConfiguration configuration = SecurityConfigurationSupport.getGlobalSignatureSigningConfiguration();
            SignatureSigningParameters signatureSigningParameters = new SignatureSigningParameters();
            signatureSigningParameters.setSigningCredential((Credential)credential);
            signatureSigningParameters.setSignatureAlgorithm(this.getAlgorithmURI(((X509Certificate)cert).getSigAlgName()));
            signatureSigningParameters.setSignatureHMACOutputLength(configuration.getSignatureHMACOutputLength());
            signatureSigningParameters.setSignatureCanonicalizationAlgorithm(configuration.getSignatureCanonicalizationAlgorithm());
            SignatureSupport.prepareSignatureParams((org.opensaml.xmlsec.signature.Signature)signature, (SignatureSigningParameters)signatureSigningParameters);
            samlObject.setSignature(signature);
            XMLObjectProviderRegistrySupport.getMarshallerFactory().getMarshaller((XMLObject)samlObject).marshall((XMLObject)samlObject);
            Signer.signObject((org.opensaml.xmlsec.signature.Signature)signature);
        }
        catch (Exception e) {
            throw new AnalyticsException(e.getMessage(), AnalyticsErrorType.CONNECTIVITY);
        }
    }

    private String getAlgorithmURI(String algorithm) {
        SignatureSigningConfiguration configuration = SecurityConfigurationSupport.getGlobalSignatureSigningConfiguration();
        for (String alg : configuration.getSignatureAlgorithms()) {
            if (!algorithm.equalsIgnoreCase(AlgorithmSupport.getAlgorithmID((String)alg))) continue;
            return alg;
        }
        return null;
    }
}

