/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.salesforce.analytics.internal.connection.service;

import com.sforce.soap.partner.Connector;
import com.sforce.soap.partner.PartnerConnection;
import com.sforce.soap.partner.fault.ApiFault;
import com.sforce.ws.ConnectionException;
import com.sforce.ws.ConnectorConfig;
import com.sforce.ws.SessionRenewer;
import javax.xml.namespace.QName;
import org.mule.modules.salesforce.analytics.internal.connection.param.bundle.ParamsBundle;
import org.mule.modules.salesforce.analytics.internal.connection.service.AbstractOAuthConnectionService;
import org.mule.modules.salesforce.analytics.internal.util.ConnectionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicConnectionService
extends AbstractOAuthConnectionService {
    private static final Logger logger = LoggerFactory.getLogger(BasicConnectionService.class);

    public PartnerConnection login(ParamsBundle paramsBundle, SessionRenewer sessionRenewer) throws org.mule.runtime.api.connection.ConnectionException {
        logger.debug("Logging in into Salesforce using user credentials.");
        try {
            String token = paramsBundle.getConnectionAuthParams().getSecurityToken() == null ? "" : paramsBundle.getConnectionAuthParams().getSecurityToken();
            String password = paramsBundle.getConnectionAuthParams().getPassword() + token;
            ConnectorConfig config = new ConnectorConfig();
            config.setUsername(paramsBundle.getConnectionAuthParams().getUsername());
            config.setPassword(password);
            config.setAuthEndpoint(paramsBundle.getConnectionAuthParams().getUrl());
            config.setSessionRenewer(sessionRenewer);
            config.setSslContext(paramsBundle.getSslContext());
            ConnectionUtil.enrichWithProxyConfig(config, paramsBundle.getProxySettingsParams());
            ConnectionUtil.enrichWithConnectionConfig(config, paramsBundle.getConnectionAdvancedParamsWithSession());
            PartnerConnection partnerConnection = Connector.newConnection((ConnectorConfig)config);
            this.switchEndpointToMutualTlsIfNeeded(partnerConnection);
            return partnerConnection;
        }
        catch (ApiFault e) {
            throw new org.mule.runtime.api.connection.ConnectionException(e.getExceptionMessage(), (Throwable)e);
        }
        catch (ConnectionException e) {
            throw new org.mule.runtime.api.connection.ConnectionException(e.getMessage(), (Throwable)e);
        }
    }

    public static class SessionRenewerHandler
    implements SessionRenewer {
        public SessionRenewer.SessionRenewalHeader renewSession(ConnectorConfig connectorConfig) throws ConnectionException {
            PartnerConnection partnerConnection = Connector.newConnection((ConnectorConfig)connectorConfig);
            SessionRenewer.SessionRenewalHeader sessionRenewalHeader = new SessionRenewer.SessionRenewalHeader();
            sessionRenewalHeader.name = new QName("urn:com.sforce.soap.partner.soap.sforce.com", "SessionHeader");
            sessionRenewalHeader.headerElement = partnerConnection.getSessionHeader();
            connectorConfig.setSessionId(partnerConnection.getConfig().getSessionId());
            return sessionRenewalHeader;
        }
    }
}

