/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.salesforce.analytics.internal.connection.provider;

import com.sforce.soap.partner.PartnerConnection;
import org.mule.modules.salesforce.analytics.internal.connection.ConnectionServiceFactory;
import org.mule.modules.salesforce.analytics.internal.connection.SalesforceAnalyticsConnection;
import org.mule.modules.salesforce.analytics.internal.connection.param.AdvancedParams;
import org.mule.modules.salesforce.analytics.internal.connection.param.OAuth2Params;
import org.mule.modules.salesforce.analytics.internal.connection.param.ProxySettingsParams;
import org.mule.modules.salesforce.analytics.internal.connection.param.bundle.OAuth2ParamsBundle;
import org.mule.modules.salesforce.analytics.internal.connection.provider.AbstractConnectionProvider;
import org.mule.modules.salesforce.analytics.internal.connection.service.OAuthConnectionService;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.connectivity.oauth.AuthorizationCode;
import org.mule.runtime.extension.api.annotation.connectivity.oauth.OAuthCallbackValue;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.connectivity.oauth.AuthorizationCodeState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AuthorizationCode(authorizationUrl="https://login.salesforce.com/services/oauth2/authorize", accessTokenUrl="https://login.salesforce.com/services/oauth2/token")
@Alias(value="config-with-oauth")
@DisplayName(value="OAuth v2.0")
public class OAuthConnectionProvider
extends AbstractConnectionProvider {
    private static final Logger logger = LoggerFactory.getLogger(OAuthConnectionProvider.class);
    @ParameterGroup(name="Connection")
    @Placement(order=1)
    private OAuth2Params oAuth2Params;
    @ParameterGroup(name="Advanced")
    @Placement(order=2)
    private AdvancedParams oAuthAdvancedParams;
    @ParameterGroup(name="Proxy")
    @Placement(order=4)
    private ProxySettingsParams proxySettingsParams;
    @OAuthCallbackValue(expression="#[payload.instance_url]")
    private String instanceId;
    private AuthorizationCodeState authorizationCodeState;
    private ConnectionServiceFactory connectionServiceFactory = new ConnectionServiceFactory();

    public SalesforceAnalyticsConnection connect() throws ConnectionException {
        OAuth2ParamsBundle paramBundle = new OAuth2ParamsBundle();
        paramBundle.setoAuth2Params(this.oAuth2Params);
        paramBundle.setoAuthAdvancedParams(this.oAuthAdvancedParams);
        paramBundle.setProxySettingsParams(this.proxySettingsParams);
        OAuthConnectionService oAuthConnectionService = this.connectionServiceFactory.oAuthConnectionService(this.authorizationCodeState, this.instanceId);
        PartnerConnection partnerConnection = oAuthConnectionService.login(paramBundle);
        SalesforceAnalyticsConnection salesforceAnalyticsConnection = new SalesforceAnalyticsConnection(partnerConnection, this.authorizationCodeState.getResourceOwnerId());
        logger.info("Connection established.SessionID: {}", (Object)salesforceAnalyticsConnection.getPartnerConnection().getConfig().getSessionId());
        return salesforceAnalyticsConnection;
    }

    public AuthorizationCodeState getAuthorizationCodeState() {
        return this.authorizationCodeState;
    }

    public void setAuthorizationCodeState(AuthorizationCodeState state) {
        this.authorizationCodeState = state;
    }

    public ProxySettingsParams getProxySettingsParams() {
        return this.proxySettingsParams;
    }

    public void setProxySettingsParams(ProxySettingsParams proxySettingsParams) {
        this.proxySettingsParams = proxySettingsParams;
    }

    public void setoAuth2Params(OAuth2Params oAuth2Params) {
        this.oAuth2Params = oAuth2Params;
    }

    public void setoAuthAdvancedParams(AdvancedParams oAuthAdvancedParams) {
        this.oAuthAdvancedParams = oAuthAdvancedParams;
    }
}

