/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.salesforce.analytics.internal.connection.provider;

import com.sforce.soap.partner.PartnerConnection;
import javax.inject.Inject;
import org.mule.modules.salesforce.analytics.internal.connection.ConnectionServiceFactory;
import org.mule.modules.salesforce.analytics.internal.connection.SalesforceAnalyticsConnection;
import org.mule.modules.salesforce.analytics.internal.connection.param.AdvancedParams;
import org.mule.modules.salesforce.analytics.internal.connection.param.ProxySettingsParams;
import org.mule.modules.salesforce.analytics.internal.connection.provider.AbstractConnectionProvider;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.http.api.HttpService;
import org.mule.sdk.api.annotation.semantics.connectivity.ExcludeFromConnectivitySchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractOAuthBearerConnectionProvider
extends AbstractConnectionProvider
implements Initialisable {
    private static final Logger logger = LoggerFactory.getLogger(AbstractOAuthBearerConnectionProvider.class);
    @Inject
    HttpService httpService;
    @Parameter
    @Placement(tab="Security", order=1)
    @DisplayName(value="TLS configuration")
    @Summary(value="If the HTTPS was configured as protocol, then the user needs to configure at least the keystore configuration")
    @Optional
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @ExcludeFromConnectivitySchema
    protected TlsContextFactory tlsContextFactory;
    @ParameterGroup(name="Advanced")
    @Placement(order=2)
    AdvancedParams oAuthAdvancedParams;
    @ParameterGroup(name="Proxy")
    @Placement(order=4)
    ProxySettingsParams proxySettingsParams;
    ConnectionServiceFactory connectionServiceFactory = new ConnectionServiceFactory();

    public SalesforceAnalyticsConnection connect() throws ConnectionException {
        PartnerConnection partnerConnection = this.createPartnerConnection();
        SalesforceAnalyticsConnection salesforceAnalyticsConnection = new SalesforceAnalyticsConnection(partnerConnection, null);
        logger.info("Connection established.SessionID: {}", (Object)salesforceAnalyticsConnection.getPartnerConnection().getConfig().getSessionId());
        return salesforceAnalyticsConnection;
    }

    public void initialise() throws InitialisationException {
        LifecycleUtils.initialiseIfNeeded((Object)this.tlsContextFactory);
    }

    public abstract PartnerConnection createPartnerConnection() throws ConnectionException;

    public AdvancedParams getoAuthAdvancedParams() {
        return this.oAuthAdvancedParams;
    }

    public void setoAuthAdvancedParams(AdvancedParams oAuthAdvancedParams) {
        this.oAuthAdvancedParams = oAuthAdvancedParams;
    }

    public ProxySettingsParams getProxySettingsParams() {
        return this.proxySettingsParams;
    }

    public void setProxySettingsParams(ProxySettingsParams proxySettingsParams) {
        this.proxySettingsParams = proxySettingsParams;
    }
}

