/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.salesforce.analytics.internal.connection.provider;

import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import javax.annotation.Nullable;
import javax.net.ssl.SSLContext;
import org.mule.connectors.commons.template.connection.ConnectorConnectionProvider;
import org.mule.modules.salesforce.analytics.internal.connection.SalesforceAnalyticsConnection;
import org.mule.modules.salesforce.analytics.internal.error.AnalyticsErrorType;
import org.mule.modules.salesforce.analytics.internal.error.exception.AnalyticsException;
import org.mule.runtime.api.connection.CachedConnectionProvider;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractConnectionProvider
extends ConnectorConnectionProvider<SalesforceAnalyticsConnection>
implements CachedConnectionProvider<SalesforceAnalyticsConnection> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractConnectionProvider.class);

    public void disconnect(SalesforceAnalyticsConnection connection) {
        ConnectionValidationResult validationResult = this.validate(connection);
        if (!validationResult.isValid()) {
            logger.warn("No valid connection");
        } else {
            connection.disconnect();
        }
    }

    public ConnectionValidationResult validate(SalesforceAnalyticsConnection connection) {
        try {
            connection.validate();
            return ConnectionValidationResult.success();
        }
        catch (Exception e) {
            return ConnectionValidationResult.failure((String)e.getMessage(), (Exception)e);
        }
    }

    @Nullable
    protected SSLContext getSslContext(TlsContextFactory tlsContextFactory) {
        if (tlsContextFactory != null && tlsContextFactory.isKeyStoreConfigured()) {
            try {
                return tlsContextFactory.createSslContext();
            }
            catch (KeyManagementException | NoSuchAlgorithmException e) {
                throw new AnalyticsException("Unable to create the SSL context.", AnalyticsErrorType.CONNECTIVITY, e);
            }
        }
        return null;
    }
}

