/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.salesforce.analytics.internal.connection;

import com.sforce.soap.partner.PartnerConnection;
import com.sforce.ws.ConnectionException;
import org.mule.connectors.commons.template.connection.ConnectorConnection;
import org.mule.modules.salesforce.analytics.internal.error.AnalyticsErrorType;
import org.mule.modules.salesforce.analytics.internal.error.exception.AnalyticsException;

public class SalesforceAnalyticsConnection
implements ConnectorConnection {
    private PartnerConnection partnerConnection;
    private String resourceOwnerId;

    public SalesforceAnalyticsConnection(PartnerConnection partnerConnection, String resourceOwnerId) {
        this.partnerConnection = partnerConnection;
        this.resourceOwnerId = resourceOwnerId;
    }

    public PartnerConnection getPartnerConnection() {
        return this.partnerConnection;
    }

    public void setPartnerConnection(PartnerConnection partnerConnection) {
        this.partnerConnection = partnerConnection;
    }

    public String getResourceOwnerId() {
        return this.resourceOwnerId;
    }

    public void disconnect() {
        if (this.partnerConnection == null) {
            return;
        }
        try {
            this.partnerConnection.logout();
        }
        catch (ConnectionException e) {
            throw new AnalyticsException("Unable to disconnect!", AnalyticsErrorType.CONNECTIVITY, e.getCause());
        }
    }

    public void validate() {
        if (this.partnerConnection == null || this.partnerConnection.getConfig() == null || this.partnerConnection.getConfig().getSessionId() == null) {
            throw new AnalyticsException("Invalid session!", AnalyticsErrorType.CONNECTIVITY);
        }
        try {
            this.partnerConnection.getServerTimestamp();
        }
        catch (ConnectionException e) {
            throw new AnalyticsException("The obtained connection is not valid.", AnalyticsErrorType.CONNECTIVITY, e);
        }
    }
}

