/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.salesforce.analytics.internal.connection;

import org.apache.commons.lang3.StringUtils;
import org.mule.modules.salesforce.analytics.internal.connection.param.AdvancedParams;
import org.mule.modules.salesforce.analytics.internal.connection.param.ProxySettingsParams;
import org.mule.modules.salesforce.analytics.internal.connection.param.bundle.BaseOAuthParamsBundle;
import org.mule.modules.salesforce.analytics.internal.connection.service.BasicConnectionService;
import org.mule.modules.salesforce.analytics.internal.connection.service.OAuthConnectionService;
import org.mule.modules.salesforce.analytics.internal.connection.service.OAuthTokenBearerService;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.extension.api.connectivity.oauth.AuthorizationCodeState;
import org.mule.runtime.http.api.HttpService;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpClientConfiguration;
import org.mule.runtime.http.api.client.proxy.ProxyConfig;
import org.mule.runtime.http.api.client.proxy.ProxyConfigBuilder;
import org.mule.runtime.http.api.tcp.TcpClientSocketProperties;
import org.mule.runtime.http.api.tcp.TcpClientSocketPropertiesBuilder;

public class ConnectionServiceFactory {
    private static final String HTTP_CLIENT_CONFIG = "httpClientConfig";

    public BasicConnectionService basicConnectionService() {
        return new BasicConnectionService();
    }

    public OAuthConnectionService oAuthConnectionService(AuthorizationCodeState authorizationCodeState, String instanceId) {
        return new OAuthConnectionService(authorizationCodeState, instanceId);
    }

    public OAuthTokenBearerService oAuthTokenBearerService(HttpService httpService, BaseOAuthParamsBundle paramsBundle) {
        HttpClient httpClient = this.createHttpClient(paramsBundle.getProxySettingsParams(), paramsBundle.getoAuthAdvancedParams(), httpService, paramsBundle.getTlsContextFactory());
        return new OAuthTokenBearerService(httpClient, paramsBundle);
    }

    private HttpClient createHttpClient(ProxySettingsParams proxySettingsParams, AdvancedParams oAuthAdvancedParams, HttpService httpService, TlsContextFactory tlsContextFactory) {
        HttpClientConfiguration.Builder httpClientConfigurationBuilder = new HttpClientConfiguration.Builder().setName(HTTP_CLIENT_CONFIG);
        if (proxySettingsParams != null && StringUtils.isNotBlank((CharSequence)proxySettingsParams.getProxyHost())) {
            ProxyConfigBuilder proxyConfigBuilder = ProxyConfig.builder();
            ((ProxyConfigBuilder)proxyConfigBuilder.host(proxySettingsParams.getProxyHost())).port(proxySettingsParams.getProxyPort().intValue());
            if (StringUtils.isNotBlank((CharSequence)proxySettingsParams.getProxyUsername()) && StringUtils.isNotBlank((CharSequence)proxySettingsParams.getProxyPassword())) {
                ((ProxyConfigBuilder)proxyConfigBuilder.username(proxySettingsParams.getProxyUsername())).password(proxySettingsParams.getProxyPassword());
            }
            httpClientConfigurationBuilder.setProxyConfig(proxyConfigBuilder.build());
        }
        if (oAuthAdvancedParams != null) {
            TcpClientSocketPropertiesBuilder tcpClientSocketPropertiesBuilder = TcpClientSocketProperties.builder();
            if (oAuthAdvancedParams.getConnectionTimeout() != null) {
                tcpClientSocketPropertiesBuilder.connectionTimeout(Integer.valueOf(oAuthAdvancedParams.getConnectionTimeout() == 0 ? -1 : (int)oAuthAdvancedParams.getConnectionTimeoutTimeUnit().toMillis(oAuthAdvancedParams.getConnectionTimeout().intValue())));
            }
            if (oAuthAdvancedParams.getReadTimeout() != null) {
                tcpClientSocketPropertiesBuilder.clientTimeout(Integer.valueOf((int)oAuthAdvancedParams.getReadTimeoutTimeUnit().toMillis(oAuthAdvancedParams.getReadTimeout().intValue())));
            }
            httpClientConfigurationBuilder.setClientSocketProperties(tcpClientSocketPropertiesBuilder.build());
        }
        httpClientConfigurationBuilder.setTlsContextFactory(tlsContextFactory);
        return httpService.getClientFactory().create(httpClientConfigurationBuilder.build());
    }
}

