/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.redis.internal.service.noncluster;

import java.util.Objects;
import org.mule.extension.redis.internal.service.RedisClientAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.BinaryJedisPubSub;
import redis.clients.jedis.Jedis;

public class JedisClientAdapter
implements RedisClientAdapter {
    private static final Logger logger = LoggerFactory.getLogger(JedisClientAdapter.class);
    private Jedis client;

    public JedisClientAdapter(Jedis client) {
        Objects.requireNonNull(client, "Jedis client cannot be null.");
        this.client = client;
    }

    @Override
    public void psubscribe(BinaryJedisPubSub jedisPubSub, byte[][] patterns) {
        logger.debug("Calling \"psubscribe\" on client.");
        this.client.psubscribe(jedisPubSub, patterns);
    }

    @Override
    public void close() {
        logger.debug("Calling \"close\" on client.");
        this.client.close();
    }
}

