/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.redis.internal.service.factory;

import java.util.Objects;
import org.mule.extension.redis.internal.connection.RedisClusteredConnection;
import org.mule.extension.redis.internal.connection.RedisConnection;
import org.mule.extension.redis.internal.connection.RedisPoolConnection;
import org.mule.extension.redis.internal.service.ClusteredApiService;
import org.mule.extension.redis.internal.service.MessagingAPIService;
import org.mule.extension.redis.internal.service.PooledApiService;
import org.mule.extension.redis.internal.service.RedisAPIService;
import org.mule.extension.redis.internal.service.RedisClientAdapter;
import org.mule.extension.redis.internal.service.RedisMessagingAPIService;
import org.mule.extension.redis.internal.service.dto.MessageDTO;

public class ServiceFactory {
    public static ServiceFactory create() {
        return new ServiceFactory();
    }

    public RedisAPIService getService(RedisConnection connection) {
        if (connection instanceof RedisClusteredConnection) {
            return new ClusteredApiService((RedisClusteredConnection)connection);
        }
        if (connection instanceof RedisPoolConnection) {
            return new PooledApiService((RedisPoolConnection)connection);
        }
        return null;
    }

    public MessagingAPIService<MessageDTO> getMessagingAPIService(RedisClientAdapter redisClient) {
        Objects.requireNonNull(redisClient, "RedisClientAdapter cannot be null.");
        return new RedisMessagingAPIService(redisClient);
    }
}

